/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.webservice;

import java.net.URL;
import java.util.concurrent.ConcurrentMap;
import javax.xml.namespace.QName;
import org.flowable.engine.impl.bpmn.webservice.MessageDefinition;
import org.flowable.engine.impl.bpmn.webservice.MessageInstance;
import org.flowable.engine.impl.bpmn.webservice.Operation;
import org.flowable.engine.impl.bpmn.webservice.OperationImplementation;
import org.flowable.engine.impl.webservice.WSService;

public class WSOperation
implements OperationImplementation {
    protected String id;
    protected String name;
    protected WSService service;

    public WSOperation(String id, String operationName, WSService service) {
        this.id = id;
        this.name = operationName;
        this.service = service;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MessageInstance sendFor(MessageInstance message, Operation operation, ConcurrentMap<QName, URL> overridenEndpointAddresses) throws Exception {
        Object[] inArguments = this.getInArguments(message);
        Object[] outArguments = this.getOutArguments(operation);
        Object[] arguments = new Object[inArguments.length + outArguments.length];
        System.arraycopy(inArguments, 0, arguments, 0, inArguments.length);
        Object[] results = this.safeSend(arguments, overridenEndpointAddresses);
        return this.createResponseMessage(results, operation);
    }

    private Object[] getInArguments(MessageInstance message) {
        return message.getStructureInstance().toArray();
    }

    private Object[] getOutArguments(Operation operation) {
        MessageDefinition outMessage = operation.getOutMessage();
        if (outMessage != null) {
            return outMessage.createInstance().getStructureInstance().toArray();
        }
        return new Object[0];
    }

    private Object[] safeSend(Object[] arguments, ConcurrentMap<QName, URL> overridenEndpointAddresses) throws Exception {
        Object[] results = null;
        results = this.service.getClient().send(this.name, arguments, overridenEndpointAddresses);
        if (results == null) {
            results = new Object[]{};
        }
        return results;
    }

    private MessageInstance createResponseMessage(Object[] results, Operation operation) {
        MessageInstance message = null;
        MessageDefinition outMessage = operation.getOutMessage();
        if (outMessage != null) {
            message = outMessage.createInstance();
            message.getStructureInstance().loadFrom(results);
        }
        return message;
    }

    public WSService getService() {
        return this.service;
    }
}

