/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.SendEventServiceTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.CorrelationUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.engine.impl.util.EventInstanceBpmnUtil;
import org.flowable.engine.impl.util.JobUtil;
import org.flowable.eventregistry.api.EventRegistry;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventregistry.api.runtime.EventPayloadInstance;
import org.flowable.eventregistry.impl.runtime.EventInstanceImpl;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.EventModel;
import org.flowable.eventsubscription.api.EventSubscription;
import org.flowable.eventsubscription.service.EventSubscriptionService;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;

public class SendEventTaskActivityBehavior
extends AbstractBpmnActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected SendEventServiceTask sendEventServiceTask;

    public SendEventTaskActivityBehavior(SendEventServiceTask sendEventServiceTask) {
        this.sendEventServiceTask = sendEventServiceTask;
    }

    @Override
    public void execute(DelegateExecution execution) {
        boolean sendSynchronously;
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        EventRegistry eventRegistry = CommandContextUtil.getEventRegistry(commandContext);
        EventModel eventModel = this.getEventModel(commandContext, execution);
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        boolean executedAsAsyncJob = Boolean.TRUE.equals(commandContext.getAttribute("async-send-event"));
        boolean bl = sendSynchronously = this.sendEventServiceTask.isSendSynchronously() || executedAsAsyncJob;
        if (!sendSynchronously) {
            JobService jobService = processEngineConfiguration.getJobServiceConfiguration().getJobService();
            JobEntity job = JobUtil.createJob(executionEntity, (BaseElement)this.sendEventServiceTask, "async-send-event", processEngineConfiguration);
            jobService.createAsyncJob(job, true);
            jobService.scheduleAsyncJob(job);
        } else {
            Collection<EventPayloadInstance> eventPayloadInstances = EventInstanceBpmnUtil.createEventPayloadInstances(executionEntity, processEngineConfiguration.getExpressionManager(), (BaseElement)execution.getCurrentFlowElement(), eventModel);
            boolean sendOnSystemChannel = this.isSendOnSystemChannel(execution);
            List<ChannelModel> channelModels = this.getChannelModels(commandContext, execution, sendOnSystemChannel);
            EventInstanceImpl eventInstance = new EventInstanceImpl(eventModel.getKey(), eventPayloadInstances, execution.getTenantId());
            if (!channelModels.isEmpty()) {
                eventRegistry.sendEventOutbound((EventInstance)eventInstance, channelModels);
            }
            if (sendOnSystemChannel) {
                eventRegistry.sendSystemEventOutbound((EventInstance)eventInstance);
            }
        }
        if (this.sendEventServiceTask.isTriggerable() && !executedAsAsyncJob) {
            String triggerEventDefinitionKey = StringUtils.isNotEmpty((CharSequence)this.sendEventServiceTask.getTriggerEventType()) ? this.sendEventServiceTask.getTriggerEventType() : eventModel.getKey();
            EventSubscriptionEntity eventSubscription = (EventSubscriptionEntity)processEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService().createEventSubscriptionBuilder().eventType(triggerEventDefinitionKey).executionId(execution.getId()).processInstanceId(execution.getProcessInstanceId()).activityId(execution.getCurrentActivityId()).processDefinitionId(execution.getProcessDefinitionId()).scopeType("bpmn").tenantId(execution.getTenantId()).configuration(CorrelationUtil.getCorrelationKey("triggerEventCorrelationParameter", commandContext, executionEntity)).create();
            CountingEntityUtil.handleInsertEventSubscriptionEntityCount((EventSubscription)eventSubscription);
            executionEntity.getEventSubscriptions().add(eventSubscription);
        } else if (sendSynchronously && !executedAsAsyncJob || !this.sendEventServiceTask.isTriggerable() && executedAsAsyncJob) {
            this.leave(execution);
        }
    }

    protected EventModel getEventModel(CommandContext commandContext, DelegateExecution execution) {
        EventModel eventModel = null;
        eventModel = Objects.equals("", execution.getTenantId()) ? CommandContextUtil.getEventRepositoryService(commandContext).getEventModelByKey(this.sendEventServiceTask.getEventType()) : CommandContextUtil.getEventRepositoryService(commandContext).getEventModelByKey(this.sendEventServiceTask.getEventType(), execution.getTenantId());
        if (eventModel == null) {
            throw new FlowableException("No event definition found for event key " + this.sendEventServiceTask.getEventType() + " for " + execution);
        }
        return eventModel;
    }

    protected boolean isSendOnSystemChannel(DelegateExecution execution) {
        List systemChannels = execution.getCurrentFlowElement().getExtensionElements().getOrDefault("systemChannel", Collections.emptyList());
        return !systemChannels.isEmpty();
    }

    protected List<ChannelModel> getChannelModels(CommandContext commandContext, DelegateExecution execution, boolean sendOnSystemChannel) {
        String channelKey;
        List channelKeyElements;
        ArrayList<String> channelKeys = new ArrayList<String>();
        Map extensionElements = execution.getCurrentFlowElement().getExtensionElements();
        if (extensionElements != null && (channelKeyElements = (List)extensionElements.get("channelKey")) != null && !channelKeyElements.isEmpty() && StringUtils.isNotEmpty((CharSequence)(channelKey = ((ExtensionElement)channelKeyElements.get(0)).getElementText()))) {
            ExpressionManager expressionManager = CommandContextUtil.getProcessEngineConfiguration(commandContext).getExpressionManager();
            Expression expression = expressionManager.createExpression(channelKey);
            Object resolvedChannelKey = expression.getValue((VariableContainer)execution);
            if (resolvedChannelKey instanceof Collection) {
                for (Object next : (Collection)resolvedChannelKey) {
                    if (next instanceof String) {
                        String[] keys = ((String)next).split(",");
                        channelKeys.addAll(Arrays.asList(keys));
                        continue;
                    }
                    throw new FlowableIllegalArgumentException("Can only use a collection of String elements for referencing channel model key");
                }
            } else if (resolvedChannelKey instanceof String) {
                String[] keys = ((String)resolvedChannelKey).split(",");
                channelKeys.addAll(Arrays.asList(keys));
            }
        }
        if (channelKeys.isEmpty()) {
            if (!sendOnSystemChannel) {
                throw new FlowableException("No channel keys configured for " + execution);
            }
            return Collections.emptyList();
        }
        EventRepositoryService eventRepositoryService = CommandContextUtil.getEventRegistryEngineConfiguration(commandContext).getEventRepositoryService();
        ArrayList<ChannelModel> channelModels = new ArrayList<ChannelModel>(channelKeys.size());
        for (String channelKey2 : channelKeys) {
            if (Objects.equals("", execution.getTenantId())) {
                channelModels.add(eventRepositoryService.getChannelModelByKey(channelKey2));
                continue;
            }
            channelModels.add(eventRepositoryService.getChannelModelByKey(channelKey2, execution.getTenantId()));
        }
        return channelModels;
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        if (this.sendEventServiceTask.isTriggerable()) {
            Object eventInstance = execution.getTransientVariables().get("eventInstance");
            if (eventInstance instanceof EventInstance) {
                EventInstanceBpmnUtil.handleEventInstanceOutParameters(execution, (BaseElement)this.sendEventServiceTask, (EventInstance)eventInstance);
            }
            CommandContext commandContext = CommandContextUtil.getCommandContext();
            ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
            EventSubscriptionService eventSubscriptionService = processEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService();
            ExecutionEntity executionEntity = (ExecutionEntity)execution;
            List<EventSubscriptionEntity> eventSubscriptions = executionEntity.getEventSubscriptions();
            String eventType = null;
            eventType = StringUtils.isNotEmpty((CharSequence)this.sendEventServiceTask.getTriggerEventType()) ? this.sendEventServiceTask.getTriggerEventType() : this.sendEventServiceTask.getEventType();
            EventModel eventModel = null;
            eventModel = Objects.equals("", execution.getTenantId()) ? CommandContextUtil.getEventRepositoryService(commandContext).getEventModelByKey(eventType) : CommandContextUtil.getEventRepositoryService(commandContext).getEventModelByKey(eventType, execution.getTenantId());
            for (EventSubscriptionEntity eventSubscription : eventSubscriptions) {
                if (!Objects.equals(eventModel.getKey(), eventSubscription.getEventType())) continue;
                eventSubscriptionService.deleteEventSubscription(eventSubscription);
            }
            this.leave(execution);
        }
    }
}

