/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.dynamic;

import java.util.ArrayList;
import java.util.HashMap;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.GraphicInfo;
import org.flowable.bpmn.model.ParallelGateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.io.InputStreamProvider;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.util.io.BytesStreamSource;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.dynamic.BaseDynamicSubProcessInjectUtil;
import org.flowable.engine.impl.dynamic.DynamicEmbeddedSubProcessBuilder;
import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.persistence.entity.ResourceEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class DynamicSubProcessJoinInjectUtil
extends BaseDynamicSubProcessInjectUtil {
    public static void injectSubProcessWithJoin(String taskId, Process process, BpmnModel bpmnModel, DynamicEmbeddedSubProcessBuilder dynamicEmbeddedSubProcessBuilder, ProcessDefinitionEntity originalProcessDefinitionEntity, DeploymentEntity newDeploymentEntity, CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        TaskEntity taskEntity = processEngineConfiguration.getTaskServiceConfiguration().getTaskService().getTask(taskId);
        FlowElement taskFlowElement = process.getFlowElement(taskEntity.getTaskDefinitionKey(), true);
        if (!(taskFlowElement instanceof UserTask)) {
            throw new FlowableException("No UserTask instance found for task definition key " + taskEntity.getTaskDefinitionKey());
        }
        UserTask userTask = (UserTask)taskFlowElement;
        if (dynamicEmbeddedSubProcessBuilder.getId() != null && process.getFlowElement(dynamicEmbeddedSubProcessBuilder.getId(), true) != null) {
            throw new FlowableIllegalArgumentException("Invalid sub-process identifier: identifier already exists in host process definition");
        }
        GraphicInfo elementGraphicInfo = bpmnModel.getGraphicInfo(userTask.getId());
        SubProcess parentSubProcess = new SubProcess();
        String subProcessId = dynamicEmbeddedSubProcessBuilder.nextSubProcessId(process.getFlowElementMap());
        parentSubProcess.setId(subProcessId);
        parentSubProcess.setName(userTask.getName());
        for (SequenceFlow incomingFlow : userTask.getIncomingFlows()) {
            incomingFlow.setTargetRef(parentSubProcess.getId());
        }
        parentSubProcess.setIncomingFlows(userTask.getIncomingFlows());
        for (SequenceFlow outgoingFlow : userTask.getOutgoingFlows()) {
            outgoingFlow.setSourceRef(parentSubProcess.getId());
        }
        parentSubProcess.setOutgoingFlows(userTask.getOutgoingFlows());
        userTask.setIncomingFlows(new ArrayList());
        userTask.setOutgoingFlows(new ArrayList());
        if (elementGraphicInfo != null) {
            elementGraphicInfo.setExpanded(Boolean.valueOf(false));
            bpmnModel.addGraphicInfo(parentSubProcess.getId(), elementGraphicInfo);
        }
        FlowElementsContainer parentContainer = userTask.getParentContainer();
        parentContainer.removeFlowElement(userTask.getId());
        bpmnModel.removeGraphicInfo(userTask.getId());
        parentSubProcess.addFlowElement((FlowElement)userTask);
        parentContainer.addFlowElement((FlowElement)parentSubProcess);
        SubProcess subProcess = new SubProcess();
        if (dynamicEmbeddedSubProcessBuilder.getId() != null) {
            subProcess.setId(dynamicEmbeddedSubProcessBuilder.getId());
        } else {
            subProcess.setId(dynamicEmbeddedSubProcessBuilder.nextSubProcessId(process.getFlowElementMap()));
        }
        dynamicEmbeddedSubProcessBuilder.setDynamicSubProcessId(subProcess.getId());
        ProcessDefinition subProcessDefinition = ProcessDefinitionUtil.getProcessDefinition(dynamicEmbeddedSubProcessBuilder.getProcessDefinitionId());
        ResourceEntity subProcessBpmnResource = processEngineConfiguration.getResourceEntityManager().findResourceByDeploymentIdAndResourceName(subProcessDefinition.getDeploymentId(), subProcessDefinition.getResourceName());
        BpmnModel bpmnModelSubProcess = new BpmnXMLConverter().convertToBpmnModel((InputStreamProvider)new BytesStreamSource(subProcessBpmnResource.getBytes()), false, false);
        for (Object flowElement : bpmnModelSubProcess.getMainProcess().getFlowElements()) {
            subProcess.addFlowElement((FlowElement)flowElement);
        }
        DynamicSubProcessJoinInjectUtil.processFlowElements(commandContext, (FlowElementsContainer)process, bpmnModel, originalProcessDefinitionEntity, newDeploymentEntity);
        HashMap<String, FlowElement> generatedIds = new HashMap<String, FlowElement>();
        DynamicSubProcessJoinInjectUtil.processSubProcessFlowElements(commandContext, subProcess.getId(), process, bpmnModel, subProcess, bpmnModelSubProcess, originalProcessDefinitionEntity, newDeploymentEntity, generatedIds, elementGraphicInfo != null);
        for (String originalFlowElementId : generatedIds.keySet()) {
            FlowElement duplicateFlowElement = (FlowElement)generatedIds.get(originalFlowElementId);
            duplicateFlowElement.getParentContainer().removeFlowElementFromMap(originalFlowElementId);
            duplicateFlowElement.getParentContainer().addFlowElementToMap(duplicateFlowElement);
        }
        parentSubProcess.addFlowElement((FlowElement)subProcess);
        StartEvent startEvent = new StartEvent();
        startEvent.setId(dynamicEmbeddedSubProcessBuilder.nextStartEventId(process.getFlowElementMap()));
        parentSubProcess.addFlowElement((FlowElement)startEvent);
        ParallelGateway fork = new ParallelGateway();
        fork.setId(dynamicEmbeddedSubProcessBuilder.nextForkGatewayId(process.getFlowElementMap()));
        parentSubProcess.addFlowElement((FlowElement)fork);
        SequenceFlow startFlow1 = new SequenceFlow(startEvent.getId(), fork.getId());
        startFlow1.setId(dynamicEmbeddedSubProcessBuilder.nextFlowId(process.getFlowElementMap()));
        parentSubProcess.addFlowElement((FlowElement)startFlow1);
        SequenceFlow forkFlow1 = new SequenceFlow(fork.getId(), userTask.getId());
        forkFlow1.setId(dynamicEmbeddedSubProcessBuilder.nextFlowId(process.getFlowElementMap()));
        parentSubProcess.addFlowElement((FlowElement)forkFlow1);
        SequenceFlow forkFlow2 = new SequenceFlow(fork.getId(), subProcess.getId());
        forkFlow2.setId(dynamicEmbeddedSubProcessBuilder.nextFlowId(process.getFlowElementMap()));
        parentSubProcess.addFlowElement((FlowElement)forkFlow2);
        EndEvent endEvent = new EndEvent();
        endEvent.setId(dynamicEmbeddedSubProcessBuilder.nextEndEventId(process.getFlowElementMap()));
        parentSubProcess.addFlowElement((FlowElement)endEvent);
        ParallelGateway join = new ParallelGateway();
        join.setId(dynamicEmbeddedSubProcessBuilder.nextJoinGatewayId(process.getFlowElementMap()));
        parentSubProcess.addFlowElement((FlowElement)join);
        SequenceFlow joinFlow1 = new SequenceFlow(userTask.getId(), join.getId());
        joinFlow1.setId(dynamicEmbeddedSubProcessBuilder.nextFlowId(process.getFlowElementMap()));
        parentSubProcess.addFlowElement((FlowElement)joinFlow1);
        SequenceFlow joinFlow2 = new SequenceFlow(subProcess.getId(), join.getId());
        joinFlow2.setId(dynamicEmbeddedSubProcessBuilder.nextFlowId(process.getFlowElementMap()));
        parentSubProcess.addFlowElement((FlowElement)joinFlow2);
        SequenceFlow endFlow = new SequenceFlow(join.getId(), endEvent.getId());
        endFlow.setId(dynamicEmbeddedSubProcessBuilder.nextFlowId(process.getFlowElementMap()));
        parentSubProcess.addFlowElement((FlowElement)endFlow);
        if (elementGraphicInfo != null) {
            GraphicInfo startGraphicInfo = new GraphicInfo(45.0, 135.0, 30.0, 30.0);
            bpmnModel.addGraphicInfo(startEvent.getId(), startGraphicInfo);
            GraphicInfo forkGraphicInfo = new GraphicInfo(120.0, 130.0, 40.0, 40.0);
            bpmnModel.addGraphicInfo(fork.getId(), forkGraphicInfo);
            bpmnModel.addFlowGraphicInfoList(startFlow1.getId(), DynamicSubProcessJoinInjectUtil.createWayPoints(75.0, 150.093, 120.375, 150.375));
            GraphicInfo taskGraphicInfo = new GraphicInfo(205.0, 30.0, 80.0, 100.0);
            bpmnModel.addGraphicInfo(userTask.getId(), taskGraphicInfo);
            bpmnModel.addFlowGraphicInfoList(forkFlow1.getId(), DynamicSubProcessJoinInjectUtil.createWayPoints(140.5, 130.5, 140.5, 70.0, 205.0, 70.0));
            GraphicInfo newSubProcessGraphicInfo = new GraphicInfo(205.0, 195.0, 80.0, 100.0);
            newSubProcessGraphicInfo.setExpanded(Boolean.valueOf(false));
            bpmnModel.addGraphicInfo(subProcess.getId(), newSubProcessGraphicInfo);
            bpmnModel.addFlowGraphicInfoList(forkFlow2.getId(), DynamicSubProcessJoinInjectUtil.createWayPoints(140.5, 169.5, 140.5, 235.0, 205.0, 235.0));
            GraphicInfo joinGraphicInfo = new GraphicInfo(350.0, 130.0, 40.0, 40.0);
            bpmnModel.addGraphicInfo(join.getId(), joinGraphicInfo);
            bpmnModel.addFlowGraphicInfoList(joinFlow1.getId(), DynamicSubProcessJoinInjectUtil.createWayPoints(305.0, 70.0, 370.0, 70.0, 370.0, 130.0));
            bpmnModel.addFlowGraphicInfoList(joinFlow2.getId(), DynamicSubProcessJoinInjectUtil.createWayPoints(305.0, 235.0, 370.0, 235.0, 370.0, 169.5));
            GraphicInfo endGraphicInfo = new GraphicInfo(435.0, 136.0, 28.0, 28.0);
            bpmnModel.addGraphicInfo(endEvent.getId(), endGraphicInfo);
            bpmnModel.addFlowGraphicInfoList(endFlow.getId(), DynamicSubProcessJoinInjectUtil.createWayPoints(389.621, 150.378, 435.0, 150.089));
        }
    }
}

