/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.migration;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.engine.migration.ActivityMigrationMapping;
import org.flowable.engine.migration.EnableActivityMapping;
import org.flowable.engine.migration.ProcessInstanceMigrationDocument;
import org.flowable.engine.migration.ProcessInstanceMigrationDocumentConverter;
import org.flowable.engine.migration.Script;

public class ProcessInstanceMigrationDocumentImpl
implements ProcessInstanceMigrationDocument {
    protected String migrateToProcessDefinitionId;
    protected String migrateToProcessDefinitionKey;
    protected Integer migrateToProcessDefinitionVersion;
    protected String migrateToProcessDefinitionTenantId;
    protected List<ActivityMigrationMapping> activityMigrationMappings;
    protected List<EnableActivityMapping> enableActivityMappings;
    protected Map<String, Map<String, Object>> activitiesLocalVariables;
    protected Map<String, Object> processInstanceVariables;
    protected Script preUpgradeScript;
    protected String preUpgradeJavaDelegate;
    protected String preUpgradeJavaDelegateExpression;
    protected Script postUpgradeScript;
    protected String postUpgradeJavaDelegate;
    protected String postUpgradeJavaDelegateExpression;

    public static ProcessInstanceMigrationDocument fromJson(String processInstanceMigrationDocumentJson) {
        return ProcessInstanceMigrationDocumentConverter.convertFromJson(processInstanceMigrationDocumentJson);
    }

    public void setMigrateToProcessDefinitionId(String processDefinitionId) {
        this.migrateToProcessDefinitionId = processDefinitionId;
    }

    public void setMigrateToProcessDefinition(String processDefinitionKey, Integer processDefinitionVersion) {
        this.migrateToProcessDefinitionKey = processDefinitionKey;
        this.migrateToProcessDefinitionVersion = processDefinitionVersion;
    }

    public void setMigrateToProcessDefinition(String processDefinitionKey, Integer processDefinitionVersion, String processDefinitionTenantId) {
        this.migrateToProcessDefinitionKey = processDefinitionKey;
        this.migrateToProcessDefinitionVersion = processDefinitionVersion;
        this.migrateToProcessDefinitionTenantId = processDefinitionTenantId;
    }

    public void setPreUpgradeScript(Script script) {
        if (this.preUpgradeJavaDelegate == null && this.preUpgradeJavaDelegateExpression == null) {
            if (script == null) {
                throw new IllegalArgumentException("Pre upgrade script can't be null.");
            }
        } else {
            throw new IllegalArgumentException("Pre upgrade script can't be set when another pre-upgrade task was already specified.");
        }
        this.preUpgradeScript = script;
    }

    public void setPreUpgradeJavaDelegate(String javaDelegateClassName) {
        if (this.preUpgradeScript == null && this.preUpgradeJavaDelegateExpression == null) {
            if (!StringUtils.isNotEmpty((CharSequence)javaDelegateClassName)) {
                throw new IllegalArgumentException("Pre upgrade java delegate can't be empty or null.");
            }
        } else {
            throw new IllegalArgumentException("Pre upgrade java delegate can't be set when another pre-upgrade task was already specified.");
        }
        this.preUpgradeJavaDelegate = javaDelegateClassName;
    }

    public void setPreUpgradeJavaDelegateExpression(String expression) {
        if (this.preUpgradeScript == null && this.preUpgradeJavaDelegate == null) {
            if (!StringUtils.isNotEmpty((CharSequence)expression)) {
                throw new IllegalArgumentException("Pre upgrade expression can't be empty or null.");
            }
        } else {
            throw new IllegalArgumentException("Pre upgrade expression can't be set when another pre-upgrade task was already specified.");
        }
        this.preUpgradeJavaDelegateExpression = expression;
    }

    public void setPostUpgradeScript(Script script) {
        if (this.postUpgradeJavaDelegate == null && this.postUpgradeJavaDelegateExpression == null) {
            if (script == null) {
                throw new IllegalArgumentException("Post upgrade script can't be null.");
            }
        } else {
            throw new IllegalArgumentException("Post upgrade script can't be set when another post-upgrade task was already specified.");
        }
        this.postUpgradeScript = script;
    }

    public void setPostUpgradeJavaDelegate(String javaDelegateClassName) {
        if (this.postUpgradeScript == null && this.postUpgradeJavaDelegateExpression == null) {
            if (!StringUtils.isNotEmpty((CharSequence)javaDelegateClassName)) {
                throw new IllegalArgumentException("Post upgrade java delegate can't be empty or null.");
            }
        } else {
            throw new IllegalArgumentException("Post upgrade java delegate can't be set when another post-upgrade task was already specified.");
        }
        this.postUpgradeJavaDelegate = javaDelegateClassName;
    }

    public void setPostUpgradeJavaDelegateExpression(String expression) {
        if (this.postUpgradeScript == null && this.postUpgradeJavaDelegate == null) {
            if (!StringUtils.isNotEmpty((CharSequence)expression)) {
                throw new IllegalArgumentException("Post upgrade expression can't be empty or null.");
            }
        } else {
            throw new IllegalArgumentException("Post upgrade expression can't be set when another post-upgrade task was already specified.");
        }
        this.postUpgradeJavaDelegateExpression = expression;
    }

    @Override
    public String getMigrateToProcessDefinitionId() {
        return this.migrateToProcessDefinitionId;
    }

    @Override
    public String getMigrateToProcessDefinitionKey() {
        return this.migrateToProcessDefinitionKey;
    }

    @Override
    public Integer getMigrateToProcessDefinitionVersion() {
        return this.migrateToProcessDefinitionVersion;
    }

    @Override
    public String getMigrateToProcessDefinitionTenantId() {
        return this.migrateToProcessDefinitionTenantId;
    }

    @Override
    public Script getPreUpgradeScript() {
        return this.preUpgradeScript;
    }

    @Override
    public String getPreUpgradeJavaDelegate() {
        return this.preUpgradeJavaDelegate;
    }

    @Override
    public String getPreUpgradeJavaDelegateExpression() {
        return this.preUpgradeJavaDelegateExpression;
    }

    @Override
    public Script getPostUpgradeScript() {
        return this.postUpgradeScript;
    }

    @Override
    public String getPostUpgradeJavaDelegate() {
        return this.postUpgradeJavaDelegate;
    }

    @Override
    public String getPostUpgradeJavaDelegateExpression() {
        return this.postUpgradeJavaDelegateExpression;
    }

    public void setActivityMigrationMappings(List<ActivityMigrationMapping> activityMigrationMappings) {
        List<String> duplicates = ProcessInstanceMigrationDocumentImpl.findDuplicatedFromActivityIds(activityMigrationMappings);
        if (!duplicates.isEmpty()) {
            throw new FlowableException("From activity '" + Arrays.toString(duplicates.toArray()) + "' is mapped more than once");
        }
        this.activityMigrationMappings = activityMigrationMappings;
        this.activitiesLocalVariables = ProcessInstanceMigrationDocumentImpl.buildActivitiesLocalVariablesMap(activityMigrationMappings);
    }

    public void setEnableActivityMappings(List<EnableActivityMapping> enableActivityMappings) {
        this.enableActivityMappings = enableActivityMappings;
    }

    protected static List<String> findDuplicatedFromActivityIds(List<ActivityMigrationMapping> activityMigrationMappings) {
        Map frequencyMap = activityMigrationMappings.stream().filter(mapping -> !mapping.isToParentProcess()).flatMap(mapping -> mapping.getFromActivityIds().stream()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        List<String> duplicatedActivityIds = frequencyMap.entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        return duplicatedActivityIds;
    }

    protected static Map<String, Map<String, Object>> buildActivitiesLocalVariablesMap(List<ActivityMigrationMapping> activityMigrationMappings) {
        HashMap<String, Map<String, Object>> variablesMap = new HashMap<String, Map<String, Object>>();
        activityMigrationMappings.forEach(mapping -> mapping.getToActivityIds().forEach(activityId -> {
            Map<String, Object> mappedLocalVariables = null;
            if (mapping instanceof ActivityMigrationMapping.OneToOneMapping) {
                mappedLocalVariables = ((ActivityMigrationMapping.OneToOneMapping)mapping).getActivityLocalVariables();
            }
            if (mapping instanceof ActivityMigrationMapping.ManyToOneMapping) {
                mappedLocalVariables = ((ActivityMigrationMapping.ManyToOneMapping)mapping).getActivityLocalVariables();
            }
            if (mapping instanceof ActivityMigrationMapping.OneToManyMapping) {
                mappedLocalVariables = ((ActivityMigrationMapping.OneToManyMapping)mapping).getActivitiesLocalVariables().get(activityId);
            }
            if (mappedLocalVariables != null && !mappedLocalVariables.isEmpty()) {
                Map activityLocalVariables = variablesMap.computeIfAbsent((String)activityId, key -> new HashMap());
                activityLocalVariables.putAll(mappedLocalVariables);
            }
        }));
        return variablesMap;
    }

    @Override
    public List<ActivityMigrationMapping> getActivityMigrationMappings() {
        return this.activityMigrationMappings;
    }

    @Override
    public List<EnableActivityMapping> getEnableActivityMappings() {
        return this.enableActivityMappings;
    }

    @Override
    public Map<String, Map<String, Object>> getActivitiesLocalVariables() {
        return this.activitiesLocalVariables;
    }

    public void setProcessInstanceVariables(Map<String, Object> processInstanceVariables) {
        this.processInstanceVariables = processInstanceVariables;
    }

    @Override
    public Map<String, Object> getProcessInstanceVariables() {
        return this.processInstanceVariables;
    }

    @Override
    public String asJsonString() {
        JsonNode jsonNode = ProcessInstanceMigrationDocumentConverter.convertToJson(this);
        return jsonNode.toString();
    }

    public String toString() {
        return ProcessInstanceMigrationDocumentConverter.convertToJsonString(this);
    }
}

