/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.db;

import java.sql.Connection;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.db.DbSchemaManager;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.impl.util.CommandContextUtil;

public class FormDbSchemaManager
implements DbSchemaManager {
    public static String LIQUIBASE_CHANGELOG = "org/flowable/form/db/liquibase/flowable-form-db-changelog.xml";

    public void dbSchemaCreate() {
        Liquibase liquibase = FormDbSchemaManager.createLiquibaseInstance();
        try {
            liquibase.update("form");
        }
        catch (Exception e) {
            throw new FlowableException("Error creating form engine tables", (Throwable)e);
        }
    }

    public void dbSchemaDrop() {
        Liquibase liquibase = FormDbSchemaManager.createLiquibaseInstance();
        try {
            liquibase.dropAll();
        }
        catch (Exception e) {
            throw new FlowableException("Error dropping form engine tables", (Throwable)e);
        }
    }

    public String dbSchemaUpdate() {
        this.dbSchemaCreate();
        return null;
    }

    protected static Liquibase createLiquibaseInstance() {
        try {
            Connection jdbcConnection = null;
            CommandContext commandContext = CommandContextUtil.getCommandContext();
            FormEngineConfiguration formEngineConfiguration = CommandContextUtil.getFormEngineConfiguration(commandContext);
            jdbcConnection = commandContext == null ? CommandContextUtil.getFormEngineConfiguration(commandContext).getDataSource().getConnection() : CommandContextUtil.getDbSqlSession(commandContext).getSqlSession().getConnection();
            if (!jdbcConnection.getAutoCommit()) {
                jdbcConnection.commit();
            }
            JdbcConnection connection = new JdbcConnection(jdbcConnection);
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
            database.setDatabaseChangeLogTableName("ACT_FO_" + database.getDatabaseChangeLogTableName());
            database.setDatabaseChangeLogLockTableName("ACT_FO_" + database.getDatabaseChangeLogLockTableName());
            if (StringUtils.isNotEmpty((CharSequence)formEngineConfiguration.getDatabaseSchema())) {
                database.setDefaultSchemaName(formEngineConfiguration.getDatabaseSchema());
                database.setLiquibaseSchemaName(formEngineConfiguration.getDatabaseSchema());
            }
            if (StringUtils.isNotEmpty((CharSequence)formEngineConfiguration.getDatabaseCatalog())) {
                database.setDefaultCatalogName(formEngineConfiguration.getDatabaseCatalog());
                database.setLiquibaseCatalogName(formEngineConfiguration.getDatabaseCatalog());
            }
            Liquibase liquibase = new Liquibase(LIQUIBASE_CHANGELOG, (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            return liquibase;
        }
        catch (Exception e) {
            throw new FlowableException("Error creating liquibase instance", (Throwable)e);
        }
    }
}

