/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.repository;

import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.form.api.FormDeployment;
import org.flowable.form.api.FormDeploymentBuilder;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.impl.FormRepositoryServiceImpl;
import org.flowable.form.engine.impl.persistence.entity.FormDeploymentEntity;
import org.flowable.form.engine.impl.persistence.entity.FormResourceEntity;
import org.flowable.form.engine.impl.persistence.entity.FormResourceEntityManager;
import org.flowable.form.engine.impl.util.CommandContextUtil;

public class FormDeploymentBuilderImpl
implements FormDeploymentBuilder,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected transient FormRepositoryServiceImpl repositoryService;
    protected transient FormResourceEntityManager resourceEntityManager;
    protected FormDeploymentEntity deployment;
    protected boolean isDuplicateFilterEnabled;

    public FormDeploymentBuilderImpl() {
        FormEngineConfiguration formEngineConfiguration = CommandContextUtil.getFormEngineConfiguration();
        this.repositoryService = (FormRepositoryServiceImpl)formEngineConfiguration.getFormRepositoryService();
        this.deployment = (FormDeploymentEntity)formEngineConfiguration.getDeploymentEntityManager().create();
        this.resourceEntityManager = formEngineConfiguration.getResourceEntityManager();
    }

    public FormDeploymentBuilder addInputStream(String resourceName, InputStream inputStream) {
        if (inputStream == null) {
            throw new FlowableException("inputStream for resource '" + resourceName + "' is null");
        }
        byte[] bytes = null;
        try {
            bytes = IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new FlowableException("could not get byte array from resource '" + resourceName + "'");
        }
        if (bytes == null) {
            throw new FlowableException("byte array for resource '" + resourceName + "' is null");
        }
        FormResourceEntity resource = (FormResourceEntity)this.resourceEntityManager.create();
        resource.setName(resourceName);
        resource.setBytes(bytes);
        this.deployment.addResource(resource);
        return this;
    }

    public FormDeploymentBuilder addClasspathResource(String resource) {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(resource);
        if (inputStream == null) {
            throw new FlowableException("resource '" + resource + "' not found");
        }
        return this.addInputStream(resource, inputStream);
    }

    public FormDeploymentBuilder addString(String resourceName, String text) {
        if (text == null) {
            throw new FlowableException("text is null");
        }
        FormResourceEntity resource = (FormResourceEntity)this.resourceEntityManager.create();
        resource.setName(resourceName);
        try {
            resource.setBytes(text.getBytes(DEFAULT_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw new FlowableException("Unable to get process bytes.", (Throwable)e);
        }
        this.deployment.addResource(resource);
        return this;
    }

    public FormDeploymentBuilder addFormBytes(String resourceName, byte[] formBytes) {
        if (formBytes == null) {
            throw new FlowableException("form bytes is null");
        }
        FormResourceEntity resource = (FormResourceEntity)this.resourceEntityManager.create();
        resource.setName(resourceName);
        resource.setBytes(formBytes);
        this.deployment.addResource(resource);
        return this;
    }

    public FormDeploymentBuilder addFormDefinition(String resourceName, String formDefinition) {
        this.addString(resourceName, formDefinition);
        return this;
    }

    public FormDeploymentBuilder name(String name) {
        this.deployment.setName(name);
        return this;
    }

    public FormDeploymentBuilder category(String category) {
        this.deployment.setCategory(category);
        return this;
    }

    public FormDeploymentBuilder tenantId(String tenantId) {
        this.deployment.setTenantId(tenantId);
        return this;
    }

    public FormDeploymentBuilder parentDeploymentId(String parentDeploymentId) {
        this.deployment.setParentDeploymentId(parentDeploymentId);
        return this;
    }

    public FormDeploymentBuilder enableDuplicateFiltering() {
        this.isDuplicateFilterEnabled = true;
        return this;
    }

    public FormDeployment deploy() {
        return this.repositoryService.deploy(this);
    }

    public FormDeploymentEntity getDeployment() {
        return this.deployment;
    }

    public boolean isDuplicateFilterEnabled() {
        return this.isDuplicateFilterEnabled;
    }
}

