/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.spring.autodeployment;

import org.flowable.common.spring.CommonAutoDeploymentProperties;
import org.flowable.form.api.FormDeploymentBuilder;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.engine.FormEngine;
import org.flowable.form.spring.autodeployment.AbstractFormAutoDeploymentStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class SingleResourceAutoDeploymentStrategy
extends AbstractFormAutoDeploymentStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleResourceAutoDeploymentStrategy.class);
    public static final String DEPLOYMENT_MODE = "single-resource";

    public SingleResourceAutoDeploymentStrategy() {
    }

    public SingleResourceAutoDeploymentStrategy(CommonAutoDeploymentProperties deploymentProperties) {
        super(deploymentProperties);
    }

    protected String getDeploymentMode() {
        return DEPLOYMENT_MODE;
    }

    protected void deployResourcesInternal(String deploymentNameHint, Resource[] resources, FormEngine engine) {
        FormRepositoryService repositoryService = engine.getFormRepositoryService();
        for (Resource resource : resources) {
            String resourceName = this.determineResourceName(resource);
            FormDeploymentBuilder deploymentBuilder = repositoryService.createDeployment().enableDuplicateFiltering().name(resourceName);
            this.addResource(resource, resourceName, deploymentBuilder);
            try {
                deploymentBuilder.deploy();
            }
            catch (RuntimeException e) {
                if (this.isThrowExceptionOnDeploymentFailure()) {
                    throw e;
                }
                LOGGER.warn("Exception while autodeploying form definitions for resource {}. This exception can be ignored if the root cause indicates a unique constraint violation, which is typically caused by two (or more) servers booting up at the exact same time and deploying the same definitions. ", (Object)resource, (Object)e);
            }
        }
    }
}

