/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.dmn;

import org.flowable.dmn.api.DmnHistoryService;
import org.flowable.dmn.api.DmnManagementService;
import org.flowable.dmn.api.DmnRepositoryService;
import org.flowable.dmn.api.DmnRuleService;
import org.flowable.dmn.engine.DmnEngine;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.DmnEngines;
import org.flowable.dmn.spring.DmnEngineFactoryBean;
import org.flowable.engine.ProcessEngine;
import org.flowable.spring.boot.FlowableProperties;
import org.flowable.spring.boot.ProcessEngineAutoConfiguration;
import org.flowable.spring.boot.condition.ConditionalOnDmnEngine;
import org.flowable.spring.boot.dmn.DmnEngineAutoConfiguration;
import org.flowable.spring.boot.dmn.FlowableDmnProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnDmnEngine
@EnableConfigurationProperties(value={FlowableProperties.class, FlowableDmnProperties.class})
@AutoConfigureAfter(value={DmnEngineAutoConfiguration.class, ProcessEngineAutoConfiguration.class})
public class DmnEngineServicesAutoConfiguration {
    @Bean
    public DmnManagementService dmnManagementService(DmnEngine dmnEngine) {
        return dmnEngine.getDmnManagementService();
    }

    @Bean
    public DmnRepositoryService dmnRepositoryService(DmnEngine dmnEngine) {
        return dmnEngine.getDmnRepositoryService();
    }

    @Bean
    public DmnRuleService dmnRuleService(DmnEngine dmnEngine) {
        return dmnEngine.getDmnRuleService();
    }

    @Bean
    public DmnHistoryService dmnHistoryService(DmnEngine dmnEngine) {
        return dmnEngine.getDmnHistoryService();
    }

    @Configuration
    @ConditionalOnMissingBean(type={"org.flowable.dmn.engine.DmnEngine", "org.flowable.engine.ProcessEngine"})
    static class StandaloneEngineConfiguration {
        StandaloneEngineConfiguration() {
        }

        @Bean
        public DmnEngineFactoryBean dmnEngine(DmnEngineConfiguration dmnEngineConfiguration) {
            DmnEngineFactoryBean factory = new DmnEngineFactoryBean();
            factory.setDmnEngineConfiguration(dmnEngineConfiguration);
            return factory;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(type={"org.flowable.dmn.engine.DmnEngine"})
    @ConditionalOnBean(type={"org.flowable.engine.ProcessEngine"})
    static class AlreadyInitializedEngineConfiguration {
        AlreadyInitializedEngineConfiguration() {
        }

        @Bean
        public DmnEngine dmnEngine(ProcessEngine processEngine) {
            if (!DmnEngines.isInitialized()) {
                throw new IllegalStateException("DMN engine has not been initialized");
            }
            return DmnEngines.getDefaultDmnEngine();
        }
    }
}

