/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.idm;

import java.util.Objects;
import javax.sql.DataSource;
import org.flowable.app.spring.SpringAppEngineConfiguration;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.EngineConfigurator;
import org.flowable.idm.engine.configurator.IdmEngineConfigurator;
import org.flowable.idm.spring.SpringIdmEngineConfiguration;
import org.flowable.idm.spring.authentication.SpringEncoder;
import org.flowable.idm.spring.configurator.SpringIdmEngineConfigurator;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.flowable.spring.boot.AbstractEngineAutoConfiguration;
import org.flowable.spring.boot.BaseEngineConfigurationWithConfigurers;
import org.flowable.spring.boot.EngineConfigurationConfigurer;
import org.flowable.spring.boot.FlowableProperties;
import org.flowable.spring.boot.ProcessEngineAutoConfiguration;
import org.flowable.spring.boot.ProcessEngineServicesAutoConfiguration;
import org.flowable.spring.boot.app.AppEngineAutoConfiguration;
import org.flowable.spring.boot.app.AppEngineServicesAutoConfiguration;
import org.flowable.spring.boot.condition.ConditionalOnIdmEngine;
import org.flowable.spring.boot.idm.FlowableIdmProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.DelegatingPasswordEncoder;
import org.springframework.security.crypto.password.NoOpPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration(proxyBeanMethods=false)
@ConditionalOnIdmEngine
@EnableConfigurationProperties(value={FlowableProperties.class, FlowableIdmProperties.class})
@AutoConfigureAfter(value={AppEngineAutoConfiguration.class, ProcessEngineAutoConfiguration.class})
@AutoConfigureBefore(value={AppEngineServicesAutoConfiguration.class, ProcessEngineServicesAutoConfiguration.class})
public class IdmEngineAutoConfiguration
extends AbstractEngineAutoConfiguration {
    protected final FlowableIdmProperties idmProperties;

    public IdmEngineAutoConfiguration(FlowableProperties flowableProperties, FlowableIdmProperties idmProperties) {
        super(flowableProperties);
        this.idmProperties = idmProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringIdmEngineConfiguration idmEngineConfiguration(DataSource dataSource, PlatformTransactionManager platformTransactionManager) {
        SpringIdmEngineConfiguration configuration = new SpringIdmEngineConfiguration();
        configuration.setTransactionManager(platformTransactionManager);
        this.configureEngine((AbstractEngineConfiguration)configuration, dataSource);
        return configuration;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(type={"org.flowable.app.spring.SpringAppEngineConfiguration"})
    public static class IdmEngineAppConfiguration
    extends BaseEngineConfigurationWithConfigurers<SpringIdmEngineConfiguration> {
        @Bean
        @ConditionalOnMissingBean(name={"idmAppEngineConfigurationConfigurer"})
        public EngineConfigurationConfigurer<SpringAppEngineConfiguration> idmAppEngineConfigurationConfigurer(IdmEngineConfigurator idmEngineConfigurator) {
            return appEngineConfiguration -> appEngineConfiguration.setIdmEngineConfigurator((EngineConfigurator)idmEngineConfigurator);
        }

        @Bean
        @ConditionalOnMissingBean
        public IdmEngineConfigurator idmEngineConfigurator(SpringIdmEngineConfiguration configuration) {
            SpringIdmEngineConfigurator idmEngineConfigurator = new SpringIdmEngineConfigurator();
            idmEngineConfigurator.setIdmEngineConfiguration(configuration);
            this.invokeConfigurers(configuration);
            return idmEngineConfigurator;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(type={"org.flowable.spring.SpringProcessEngineConfiguration"})
    @ConditionalOnMissingBean(type={"org.flowable.app.spring.SpringAppEngineConfiguration"})
    public static class IdmEngineProcessConfiguration
    extends BaseEngineConfigurationWithConfigurers<SpringIdmEngineConfiguration> {
        @Bean
        @ConditionalOnMissingBean(name={"idmProcessEngineConfigurationConfigurer"})
        public EngineConfigurationConfigurer<SpringProcessEngineConfiguration> idmProcessEngineConfigurationConfigurer(IdmEngineConfigurator idmEngineConfigurator) {
            return processEngineConfiguration -> processEngineConfiguration.setIdmEngineConfigurator((EngineConfigurator)idmEngineConfigurator);
        }

        @Bean
        @ConditionalOnMissingBean
        public IdmEngineConfigurator idmEngineConfigurator(SpringIdmEngineConfiguration configuration) {
            SpringIdmEngineConfigurator idmEngineConfigurator = new SpringIdmEngineConfigurator();
            idmEngineConfigurator.setIdmEngineConfiguration(configuration);
            this.invokeConfigurers(configuration);
            return idmEngineConfigurator;
        }
    }

    @ConditionalOnClass(value={PasswordEncoder.class})
    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="flowable.idm.ldap", name={"enabled"}, havingValue="false", matchIfMissing=true)
    public static class PasswordEncoderConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public PasswordEncoder passwordEncoder(FlowableIdmProperties idmProperties) {
            BCryptPasswordEncoder encoder;
            String encoderType = idmProperties.getPasswordEncoder();
            if (Objects.equals("spring_bcrypt", encoderType)) {
                encoder = new BCryptPasswordEncoder();
            } else if (encoderType != null && encoderType.startsWith("spring_delegating")) {
                encoder = PasswordEncoderFactories.createDelegatingPasswordEncoder();
                if (encoderType.equals("spring_delegating_bcrypt")) {
                    ((DelegatingPasswordEncoder)encoder).setDefaultPasswordEncoderForMatches((PasswordEncoder)new BCryptPasswordEncoder());
                } else if (encoderType.equals("spring_delegating_noop")) {
                    ((DelegatingPasswordEncoder)encoder).setDefaultPasswordEncoderForMatches(NoOpPasswordEncoder.getInstance());
                }
            } else {
                encoder = NoOpPasswordEncoder.getInstance();
            }
            return encoder;
        }

        @Bean
        @ConditionalOnBean(value={PasswordEncoder.class})
        @ConditionalOnMissingBean(name={"passwordEncoderIdmEngineConfigurationConfigurer"})
        public EngineConfigurationConfigurer<SpringIdmEngineConfiguration> passwordEncoderIdmEngineConfigurationConfigurer(PasswordEncoder passwordEncoder) {
            return idmEngineConfiguration -> idmEngineConfiguration.setPasswordEncoder((org.flowable.idm.api.PasswordEncoder)new SpringEncoder(passwordEncoder));
        }
    }
}

