/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.idm.security;

import java.util.ArrayList;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.api.User;
import org.flowable.idm.api.UserQuery;
import org.flowable.spring.boot.ldap.FlowableLdapProperties;
import org.flowable.ui.common.security.FlowableAppUser;
import org.flowable.ui.idm.cache.UserCache;
import org.flowable.ui.idm.model.UserInformation;
import org.flowable.ui.idm.security.CustomUserDetailService;
import org.flowable.ui.idm.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.transaction.annotation.Transactional;

public class UserDetailsService
implements org.springframework.security.core.userdetails.UserDetailsService,
CustomUserDetailService {
    @Autowired
    protected UserCache userCache;
    @Autowired
    protected IdmIdentityService identityService;
    @Autowired
    protected UserService userService;
    @Autowired(required=false)
    protected FlowableLdapProperties ldapProperties;
    protected long userValidityPeriod;

    @Override
    @Transactional
    public UserDetails loadUserByUsername(String login) {
        String actualLogin = login;
        User userFromDatabase = null;
        if (this.ldapProperties == null || !this.ldapProperties.isEnabled()) {
            actualLogin = login.toLowerCase();
            userFromDatabase = (User)((UserQuery)this.identityService.createUserQuery().userIdIgnoreCase(actualLogin)).singleResult();
        } else {
            userFromDatabase = (User)((UserQuery)this.identityService.createUserQuery().userId(actualLogin)).singleResult();
        }
        if (userFromDatabase == null) {
            throw new UsernameNotFoundException("User " + actualLogin + " was not found in the database");
        }
        ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
        UserInformation userInformation = this.userService.getUserInformation(userFromDatabase.getId());
        for (String privilege : userInformation.getPrivileges()) {
            grantedAuthorities.add(new SimpleGrantedAuthority(privilege));
        }
        this.userCache.putUser(userFromDatabase.getId(), new UserCache.CachedUser(userFromDatabase, grantedAuthorities));
        return new FlowableAppUser(userFromDatabase, actualLogin, grantedAuthorities);
    }

    @Override
    @Transactional
    public UserDetails loadByUserId(String userId) {
        UserCache.CachedUser cachedUser = this.userCache.getUser(userId, true, true, false);
        if (cachedUser == null) {
            throw new UsernameNotFoundException("User " + userId + " was not found in the database");
        }
        long lastDatabaseCheck = cachedUser.getLastDatabaseCheck();
        long currentTime = System.currentTimeMillis();
        if (this.userValidityPeriod <= 0L || currentTime - lastDatabaseCheck >= this.userValidityPeriod) {
            this.userCache.invalidate(userId);
            cachedUser = this.userCache.getUser(userId, true, true, false);
            cachedUser.setLastDatabaseCheck(currentTime);
        }
        User user = cachedUser.getUser();
        String actualUserId = user.getId();
        return new FlowableAppUser(cachedUser.getUser(), actualUserId, cachedUser.getGrantedAuthorities());
    }

    public void setUserValidityPeriod(long userValidityPeriod) {
        this.userValidityPeriod = userValidityPeriod;
    }
}

