/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.idm.security;

import org.flowable.idm.api.IdmIdentityService;
import org.flowable.ui.common.security.FlowableAppUser;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.NullAuthoritiesMapper;
import org.springframework.security.core.userdetails.UserDetailsService;

public class CustomLdapAuthenticationProvider
implements AuthenticationProvider {
    protected UserDetailsService userDetailsService;
    protected IdmIdentityService identityService;
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    protected GrantedAuthoritiesMapper authoritiesMapper = new NullAuthoritiesMapper();

    public CustomLdapAuthenticationProvider(UserDetailsService userDetailsService, IdmIdentityService identityService) {
        this.userDetailsService = userDetailsService;
        this.identityService = identityService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        UsernamePasswordAuthenticationToken authenticationToken = (UsernamePasswordAuthenticationToken)authentication;
        boolean authenticated = this.identityService.checkPassword(authenticationToken.getName(), authenticationToken.getCredentials().toString());
        if (!authenticated) {
            throw new BadCredentialsException(this.messages.getMessage("LdapAuthenticationProvider.badCredentials", "Bad credentials"));
        }
        FlowableAppUser userDetails = (FlowableAppUser)this.userDetailsService.loadUserByUsername(authenticationToken.getName());
        UsernamePasswordAuthenticationToken result = new UsernamePasswordAuthenticationToken((Object)userDetails, authenticationToken.getCredentials(), this.authoritiesMapper.mapAuthorities(userDetails.getAuthorities()));
        result.setDetails(authentication.getDetails());
        return result;
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

