/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.engine.impl.bpmn.behavior.WebServiceActivityBehavior;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractExternalInvocationBpmnParseHandler;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.DataAssociation;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.ImplementationType;
import org.flowable.bpmn.model.SendTask;
import org.flowable.engine.impl.bpmn.data.AbstractDataAssociation;
import org.flowable.engine.impl.bpmn.data.IOSpecification;
import org.flowable.engine.impl.bpmn.webservice.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendTaskParseHandler
extends AbstractExternalInvocationBpmnParseHandler<SendTask> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendTaskParseHandler.class);

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return SendTask.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, SendTask sendTask) {
        ActivityImpl activity = this.createActivityOnCurrentScope(bpmnParse, (FlowElement)sendTask, "sendTask");
        activity.setAsync(sendTask.isAsynchronous());
        activity.setExclusive(!sendTask.isNotExclusive());
        if (StringUtils.isNotEmpty((CharSequence)sendTask.getType())) {
            if (sendTask.getType().equalsIgnoreCase("mail")) {
                activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createMailActivityBehavior(sendTask));
            } else if (sendTask.getType().equalsIgnoreCase("mule")) {
                activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createMuleActivityBehavior(sendTask, bpmnParse.getBpmnModel()));
            } else if (sendTask.getType().equalsIgnoreCase("camel")) {
                activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createCamelActivityBehavior(sendTask, bpmnParse.getBpmnModel()));
            }
        } else if (ImplementationType.IMPLEMENTATION_TYPE_WEBSERVICE.equalsIgnoreCase(sendTask.getImplementationType()) && StringUtils.isNotEmpty((CharSequence)sendTask.getOperationRef())) {
            if (!bpmnParse.getOperations().containsKey(sendTask.getOperationRef())) {
                LOGGER.warn("{} does not exist for sendTask {}", (Object)sendTask.getOperationRef(), (Object)sendTask.getId());
            } else {
                AbstractDataAssociation dataAssociation;
                WebServiceActivityBehavior webServiceActivityBehavior = bpmnParse.getActivityBehaviorFactory().createWebServiceActivityBehavior(sendTask);
                Operation operation = bpmnParse.getOperations().get(sendTask.getOperationRef());
                webServiceActivityBehavior.setOperation(operation);
                if (sendTask.getIoSpecification() != null) {
                    IOSpecification ioSpecification = this.createIOSpecification(bpmnParse, sendTask.getIoSpecification());
                    webServiceActivityBehavior.setIoSpecification(ioSpecification);
                }
                for (DataAssociation dataAssociationElement : sendTask.getDataInputAssociations()) {
                    dataAssociation = this.createDataInputAssociation(bpmnParse, dataAssociationElement);
                    webServiceActivityBehavior.addDataInputAssociation(dataAssociation);
                }
                for (DataAssociation dataAssociationElement : sendTask.getDataOutputAssociations()) {
                    dataAssociation = this.createDataOutputAssociation(bpmnParse, dataAssociationElement);
                    webServiceActivityBehavior.addDataOutputAssociation(dataAssociation);
                }
                activity.setActivityBehavior(webServiceActivityBehavior);
            }
        } else {
            LOGGER.warn("One of the attributes 'type' or 'operation' is mandatory on sendTask {}", (Object)sendTask.getId());
        }
    }
}

