/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;

public class IdentityLinkEntityManager
extends AbstractManager {
    public void deleteIdentityLink(IdentityLinkEntity identityLink, boolean cascadeHistory) {
        this.getDbSqlSession().delete(identityLink);
        if (cascadeHistory) {
            this.getHistoryManager().deleteHistoricIdentityLink(identityLink.getId());
        }
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, identityLink));
        }
    }

    public List<IdentityLinkEntity> findIdentityLinksByTaskId(String taskId) {
        return this.getDbSqlSession().selectList("selectIdentityLinksByTask", taskId);
    }

    public List<IdentityLinkEntity> findIdentityLinksByProcessInstanceId(String processInstanceId) {
        return this.getDbSqlSession().selectList("selectIdentityLinksByProcessInstance", processInstanceId);
    }

    public List<IdentityLinkEntity> findIdentityLinksByProcessDefinitionId(String processDefinitionId) {
        return this.getDbSqlSession().selectList("selectIdentityLinksByProcessDefinition", processDefinitionId);
    }

    public List<IdentityLinkEntity> findIdentityLinks() {
        return this.getDbSqlSession().selectList("selectIdentityLinks");
    }

    public List<IdentityLinkEntity> findIdentityLinkByTaskUserGroupAndType(String taskId, String userId, String groupId, String type) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("taskId", taskId);
        parameters.put("userId", userId);
        parameters.put("groupId", groupId);
        parameters.put("type", type);
        return this.getDbSqlSession().selectList("selectIdentityLinkByTaskUserGroupAndType", parameters);
    }

    public List<IdentityLinkEntity> findIdentityLinkByProcessInstanceUserGroupAndType(String processInstanceId, String userId, String groupId, String type) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("userId", userId);
        parameters.put("groupId", groupId);
        parameters.put("type", type);
        return this.getDbSqlSession().selectList("selectIdentityLinkByProcessInstanceUserGroupAndType", parameters);
    }

    public List<IdentityLinkEntity> findIdentityLinkByProcessDefinitionUserAndGroup(String processDefinitionId, String userId, String groupId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("processDefinitionId", processDefinitionId);
        parameters.put("userId", userId);
        parameters.put("groupId", groupId);
        return this.getDbSqlSession().selectList("selectIdentityLinkByProcessDefinitionUserAndGroup", parameters);
    }

    public void deleteIdentityLinksByTaskId(String taskId) {
        List<IdentityLinkEntity> identityLinks = this.findIdentityLinksByTaskId(taskId);
        for (IdentityLinkEntity identityLink : identityLinks) {
            this.deleteIdentityLink(identityLink, false);
        }
    }

    public void deleteIdentityLinksByProcInstance(String processInstanceId) {
        List<IdentityLinkEntity> identityLinks = this.findIdentityLinksByProcessInstanceId(processInstanceId);
        for (IdentityLinkEntity identityLink : identityLinks) {
            this.deleteIdentityLink(identityLink, false);
        }
        List<IdentityLinkEntity> identityLinksFromCache = Context.getCommandContext().getDbSqlSession().findInCache(IdentityLinkEntity.class);
        boolean alreadyDeleted = false;
        for (IdentityLinkEntity identityLinkEntity : identityLinksFromCache) {
            if (!processInstanceId.equals(identityLinkEntity.getProcessInstanceId())) continue;
            alreadyDeleted = false;
            for (IdentityLinkEntity deleted : identityLinks) {
                if (deleted.getId() == null || !deleted.getId().equals(identityLinkEntity.getId())) continue;
                alreadyDeleted = true;
                break;
            }
            if (alreadyDeleted) continue;
            this.deleteIdentityLink(identityLinkEntity, false);
        }
    }

    public void deleteIdentityLinksByProcDef(String processDefId) {
        this.getDbSqlSession().delete("deleteIdentityLinkByProcDef", processDefId);
    }
}

