/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.TimerJobQueryImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TimerJobEntity;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.job.api.Job;

public class TimerJobEntityManager
extends AbstractManager {
    public void cancelTimers(ExecutionEntity execution) {
        List<TimerJobEntity> timers = Context.getCommandContext().getTimerJobEntityManager().findTimersByExecutionId(execution.getId());
        for (TimerJobEntity timer : timers) {
            if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_CANCELED, timer));
            }
            timer.delete();
        }
    }

    public TimerJobEntity findJobById(String jobId) {
        return (TimerJobEntity)this.getDbSqlSession().selectOne("selectTimerJob", jobId);
    }

    public List<TimerJobEntity> findTimerJobsByLockOwner(String lockOwner, int start, int maxNrOfJobs) {
        return this.getDbSqlSession().selectList("selectTimerJobsByLockOwner", lockOwner, start, maxNrOfJobs);
    }

    public List<TimerJobEntity> findTimerJobsByExecutionId(String executionId) {
        return this.getDbSqlSession().selectList("selectTimerJobsByExecutionId", executionId);
    }

    public List<TimerJobEntity> findTimerJobsByProcessInstanceId(String processInstanceId) {
        return this.getDbSqlSession().selectList("selectTimerJobsByProcessInstanceId", processInstanceId);
    }

    public List<TimerJobEntity> findTimersByDuedate(Date duedate, Page page) {
        String query = "selectTimerJobsByDuedate";
        return this.getDbSqlSession().selectList("selectTimerJobsByDuedate", duedate, page);
    }

    public List<TimerJobEntity> findTimersByExecutionId(String executionId) {
        return this.getDbSqlSession().selectList("selectTimersByExecutionId", executionId);
    }

    public List<Job> findTimerJobsByQueryCriteria(TimerJobQueryImpl jobQuery, Page page) {
        String query = "selectTimerJobByQueryCriteria";
        return this.getDbSqlSession().selectList("selectTimerJobByQueryCriteria", jobQuery, page);
    }

    public List<Job> findTimerJobsByTypeAndProcessDefinitionKeyNoTenantId(String jobHandlerType, String processDefinitionKey) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("handlerType", jobHandlerType);
        params.put("processDefinitionKey", processDefinitionKey);
        return this.getDbSqlSession().selectList("selectTimerJobByTypeAndProcessDefinitionKeyNoTenantId", params);
    }

    public List<Job> findTimerJobsByTypeAndProcessDefinitionKeyAndTenantId(String jobHandlerType, String processDefinitionKey, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("handlerType", jobHandlerType);
        params.put("processDefinitionKey", processDefinitionKey);
        params.put("tenantId", tenantId);
        return this.getDbSqlSession().selectList("selectTimerJobByTypeAndProcessDefinitionKeyAndTenantId", params);
    }

    public List<Job> findTimerJobsByTypeAndProcessDefinitionId(String jobHandlerType, String processDefinitionId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("handlerType", jobHandlerType);
        params.put("processDefinitionId", processDefinitionId);
        return this.getDbSqlSession().selectList("selectTimerJobByTypeAndProcessDefinitionId", params);
    }

    public long findTimerJobCountByQueryCriteria(TimerJobQueryImpl jobQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectTimerJobCountByQueryCriteria", jobQuery);
    }

    public void updateTimerJobTenantIdForDeployment(String deploymentId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("tenantId", newTenantId);
        this.getDbSqlSession().update("updateTimerJobTenantIdForDeployment", params);
    }
}

