/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.pvm.runtime;

import java.util.List;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.pvm.PvmException;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.impl.pvm.runtime.AtomicOperation;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.ExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicOperationTransitionNotifyListenerTake
implements AtomicOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomicOperationTransitionNotifyListenerTake.class);

    @Override
    public boolean isAsync(InterpretableExecution execution) {
        return false;
    }

    @Override
    public void execute(InterpretableExecution execution) {
        TransitionImpl transition = execution.getTransition();
        List<ExecutionListener> executionListeners = transition.getExecutionListeners();
        int executionListenerIndex = execution.getExecutionListenerIndex();
        if (executionListeners.size() > executionListenerIndex) {
            execution.setEventName("take");
            execution.setEventSource(transition);
            ExecutionListener listener = executionListeners.get(executionListenerIndex);
            try {
                listener.notify((DelegateExecution)execution);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PvmException("couldn't execute event listener : " + e.getMessage(), e);
            }
            execution.setExecutionListenerIndex(executionListenerIndex + 1);
            execution.performOperation(this);
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} takes transition {}", (Object)execution, (Object)transition);
            }
            execution.setExecutionListenerIndex(0);
            execution.setEventName(null);
            execution.setEventSource(null);
            ActivityImpl activity = (ActivityImpl)execution.getActivity();
            ActivityImpl nextScope = AtomicOperationTransitionNotifyListenerTake.findNextScope(activity.getParent(), transition.getDestination());
            execution.setActivity(nextScope);
            if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createSequenceFlowTakenEvent(FlowableEngineEventType.SEQUENCEFLOW_TAKEN, transition.getId(), activity.getId(), (String)activity.getProperties().get("name"), (String)activity.getProperties().get("type"), activity.getActivityBehavior().getClass().getCanonicalName(), nextScope.getId(), (String)nextScope.getProperties().get("name"), (String)nextScope.getProperties().get("type"), nextScope.getActivityBehavior().getClass().getCanonicalName()));
            }
            execution.performOperation(TRANSITION_CREATE_SCOPE);
        }
    }

    public static ActivityImpl findNextScope(ScopeImpl outerScopeElement, ActivityImpl destination) {
        ActivityImpl nextScope = destination;
        while (nextScope.getParent() instanceof ActivityImpl && nextScope.getParent() != outerScopeElement) {
            nextScope = (ActivityImpl)nextScope.getParent();
        }
        return nextScope;
    }
}

