/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core;

import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.api.errorhandler.ErrorHandler;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.callback.LegacyCallback;
import org.flywaydb.core.internal.callback.SqlScriptFlywayCallbackFactory;
import org.flywaydb.core.internal.command.DbBaseline;
import org.flywaydb.core.internal.command.DbClean;
import org.flywaydb.core.internal.command.DbInfo;
import org.flywaydb.core.internal.command.DbMigrate;
import org.flywaydb.core.internal.command.DbRepair;
import org.flywaydb.core.internal.command.DbSchemas;
import org.flywaydb.core.internal.command.DbValidate;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.database.Connection;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.database.DatabaseFactory;
import org.flywaydb.core.internal.database.Schema;
import org.flywaydb.core.internal.exception.FlywayProUpgradeRequiredException;
import org.flywaydb.core.internal.resolver.CompositeMigrationResolver;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.schemahistory.SchemaHistoryFactory;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.VersionPrinter;
import org.flywaydb.core.internal.util.placeholder.DefaultPlaceholderReplacer;
import org.flywaydb.core.internal.util.placeholder.NoopPlaceholderReplacer;
import org.flywaydb.core.internal.util.placeholder.PlaceholderReplacer;
import org.flywaydb.core.internal.util.scanner.Scanner;

public class Flyway
implements Configuration {
    private static final Log LOG = LogFactory.getLog(Flyway.class);
    private final ClassicConfiguration configuration;
    private boolean dbConnectionInfoPrinted;

    public Flyway() {
        this.configuration = new ClassicConfiguration();
    }

    public Flyway(ClassLoader classLoader) {
        this.configuration = new ClassicConfiguration(classLoader);
    }

    @Deprecated
    public Flyway(FlywayConfiguration configuration) {
        LOG.warn("The Flyway(FlywayConfiguration) constructor has been deprecated and will be removed in Flyway 6.0. Use Flyway(Configuration) instead.");
        this.configuration = new ClassicConfiguration(configuration);
    }

    public Flyway(Configuration configuration) {
        this.configuration = new ClassicConfiguration(configuration);
    }

    public Configuration getConfiguration() {
        return new ClassicConfiguration(this.configuration);
    }

    @Override
    public Location[] getLocations() {
        return this.configuration.getLocations();
    }

    @Override
    public Charset getEncoding() {
        return this.configuration.getEncoding();
    }

    @Override
    public String[] getSchemas() {
        return this.configuration.getSchemas();
    }

    @Override
    public String getTable() {
        return this.configuration.getTable();
    }

    @Override
    public MigrationVersion getTarget() {
        return this.configuration.getTarget();
    }

    @Override
    public boolean isPlaceholderReplacement() {
        return this.configuration.isPlaceholderReplacement();
    }

    @Override
    public Map<String, String> getPlaceholders() {
        return this.configuration.getPlaceholders();
    }

    @Override
    public String getPlaceholderPrefix() {
        return this.configuration.getPlaceholderPrefix();
    }

    @Override
    public String getPlaceholderSuffix() {
        return this.configuration.getPlaceholderSuffix();
    }

    @Override
    public String getSqlMigrationPrefix() {
        return this.configuration.getSqlMigrationPrefix();
    }

    @Override
    public String getRepeatableSqlMigrationPrefix() {
        return this.configuration.getRepeatableSqlMigrationPrefix();
    }

    @Override
    public String getSqlMigrationSeparator() {
        return this.configuration.getSqlMigrationSeparator();
    }

    @Deprecated
    public String getSqlMigrationSuffix() {
        LOG.warn("sqlMigrationSuffix has been deprecated and will be removed in Flyway 6.0.0. Use sqlMigrationSuffixes instead.");
        return this.configuration.getSqlMigrationSuffixes()[0];
    }

    @Override
    public String[] getSqlMigrationSuffixes() {
        return this.configuration.getSqlMigrationSuffixes();
    }

    @Override
    public boolean isIgnoreMissingMigrations() {
        return this.configuration.isIgnoreMissingMigrations();
    }

    @Override
    public boolean isIgnoreIgnoredMigrations() {
        return this.configuration.isIgnoreIgnoredMigrations();
    }

    @Override
    public boolean isIgnoreFutureMigrations() {
        return this.configuration.isIgnoreFutureMigrations();
    }

    @Override
    public boolean isValidateOnMigrate() {
        return this.configuration.isValidateOnMigrate();
    }

    @Override
    public boolean isCleanOnValidationError() {
        return this.configuration.isCleanOnValidationError();
    }

    @Override
    public boolean isCleanDisabled() {
        return this.configuration.isCleanDisabled();
    }

    @Override
    public MigrationVersion getBaselineVersion() {
        return this.configuration.getBaselineVersion();
    }

    @Override
    public String getBaselineDescription() {
        return this.configuration.getBaselineDescription();
    }

    @Override
    public boolean isBaselineOnMigrate() {
        return this.configuration.isBaselineOnMigrate();
    }

    @Override
    public boolean isOutOfOrder() {
        return this.configuration.isOutOfOrder();
    }

    @Override
    public MigrationResolver[] getResolvers() {
        return this.configuration.getResolvers();
    }

    @Override
    public boolean isSkipDefaultResolvers() {
        return this.configuration.isSkipDefaultResolvers();
    }

    @Override
    public DataSource getDataSource() {
        return this.configuration.getDataSource();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.configuration.getClassLoader();
    }

    @Override
    public boolean isMixed() {
        return this.configuration.isMixed();
    }

    @Override
    public String getInstalledBy() {
        return this.configuration.getInstalledBy();
    }

    @Override
    public boolean isGroup() {
        return this.configuration.isGroup();
    }

    @Override
    public ErrorHandler[] getErrorHandlers() {
        return this.configuration.getErrorHandlers();
    }

    @Override
    public String[] getErrorOverrides() {
        return this.configuration.getErrorOverrides();
    }

    @Override
    public OutputStream getDryRunOutput() {
        return this.configuration.getDryRunOutput();
    }

    @Override
    public boolean isStream() {
        return this.configuration.isStream();
    }

    @Override
    public boolean isBatch() {
        return this.configuration.isBatch();
    }

    @Override
    public boolean isOracleSqlplus() {
        return this.configuration.isOracleSqlplus();
    }

    public void setDryRunOutput(OutputStream dryRunOutput) {
        this.configuration.setDryRunOutput(dryRunOutput);
    }

    public void setDryRunOutputAsFile(File dryRunOutput) {
        this.configuration.setDryRunOutputAsFile(dryRunOutput);
    }

    public void setDryRunOutputAsFileName(String dryRunOutputFileName) {
        this.configuration.setDryRunOutputAsFileName(dryRunOutputFileName);
    }

    public void setErrorHandlers(ErrorHandler ... errorHandlers) {
        this.configuration.setErrorHandlers(errorHandlers);
    }

    public void setErrorHandlersAsClassNames(String ... errorHandlerClassNames) {
        this.configuration.setErrorHandlersAsClassNames(errorHandlerClassNames);
    }

    public void setErrorOverrides(String ... errorOverrides) {
        this.configuration.setErrorOverrides(errorOverrides);
    }

    public void setGroup(boolean group) {
        this.configuration.setGroup(group);
    }

    public void setInstalledBy(String installedBy) {
        this.configuration.setInstalledBy(installedBy);
    }

    public void setMixed(boolean mixed) {
        this.configuration.setMixed(mixed);
    }

    public void setIgnoreMissingMigrations(boolean ignoreMissingMigrations) {
        this.configuration.setIgnoreMissingMigrations(ignoreMissingMigrations);
    }

    public void setIgnoreIgnoredMigrations(boolean ignoreIgnoredMigrations) {
        this.configuration.setIgnoreIgnoredMigrations(ignoreIgnoredMigrations);
    }

    public void setIgnoreFutureMigrations(boolean ignoreFutureMigrations) {
        this.configuration.setIgnoreFutureMigrations(ignoreFutureMigrations);
    }

    public void setValidateOnMigrate(boolean validateOnMigrate) {
        this.configuration.setValidateOnMigrate(validateOnMigrate);
    }

    public void setCleanOnValidationError(boolean cleanOnValidationError) {
        this.configuration.setCleanOnValidationError(cleanOnValidationError);
    }

    public void setCleanDisabled(boolean cleanDisabled) {
        this.configuration.setCleanDisabled(cleanDisabled);
    }

    public void setLocations(String ... locations) {
        this.configuration.setLocationsAsStrings(locations);
    }

    public void setEncoding(String encoding) {
        this.configuration.setEncodingAsString(encoding);
    }

    public void setSchemas(String ... schemas) {
        this.configuration.setSchemas(schemas);
    }

    public void setTable(String table) {
        this.configuration.setTable(table);
    }

    public void setTarget(MigrationVersion target) {
        this.configuration.setTarget(target);
    }

    public void setTargetAsString(String target) {
        this.configuration.setTargetAsString(target);
    }

    public void setPlaceholderReplacement(boolean placeholderReplacement) {
        this.configuration.setPlaceholderReplacement(placeholderReplacement);
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.configuration.setPlaceholders(placeholders);
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.configuration.setPlaceholderPrefix(placeholderPrefix);
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.configuration.setPlaceholderSuffix(placeholderSuffix);
    }

    public void setSqlMigrationPrefix(String sqlMigrationPrefix) {
        this.configuration.setSqlMigrationPrefix(sqlMigrationPrefix);
    }

    @Override
    public String getUndoSqlMigrationPrefix() {
        return this.configuration.getUndoSqlMigrationPrefix();
    }

    public void setUndoSqlMigrationPrefix(String undoSqlMigrationPrefix) {
        this.configuration.setUndoSqlMigrationPrefix(undoSqlMigrationPrefix);
    }

    public void setRepeatableSqlMigrationPrefix(String repeatableSqlMigrationPrefix) {
        this.configuration.setRepeatableSqlMigrationPrefix(repeatableSqlMigrationPrefix);
    }

    public void setSqlMigrationSeparator(String sqlMigrationSeparator) {
        this.configuration.setSqlMigrationSeparator(sqlMigrationSeparator);
    }

    @Deprecated
    public void setSqlMigrationSuffix(String sqlMigrationSuffix) {
        LOG.warn("sqlMigrationSuffix has been deprecated and will be removed in Flyway 6.0.0. Use sqlMigrationSuffixes instead.");
        this.configuration.setSqlMigrationSuffixes(sqlMigrationSuffix);
    }

    public void setSqlMigrationSuffixes(String ... sqlMigrationSuffixes) {
        this.configuration.setSqlMigrationSuffixes(sqlMigrationSuffixes);
    }

    public void setDataSource(DataSource dataSource) {
        this.configuration.setDataSource(dataSource);
    }

    public void setDataSource(String url, String user, String password, String ... initSqls) {
        this.configuration.setDataSource(url, user, password, initSqls);
    }

    @Deprecated
    public void setClassLoader(ClassLoader classLoader) {
        LOG.warn("Flyway.setClassLoader() has been deprecated and will be removed in Flyway 6.0. Use {@link Flyway(ClassLoader)} instead.");
        this.configuration.setClassLoader(classLoader);
    }

    public void setBaselineVersion(MigrationVersion baselineVersion) {
        this.configuration.setBaselineVersion(baselineVersion);
    }

    public void setBaselineVersionAsString(String baselineVersion) {
        this.configuration.setBaselineVersionAsString(baselineVersion);
    }

    public void setBaselineDescription(String baselineDescription) {
        this.configuration.setBaselineDescription(baselineDescription);
    }

    public void setBaselineOnMigrate(boolean baselineOnMigrate) {
        this.configuration.setBaselineOnMigrate(baselineOnMigrate);
    }

    public void setOutOfOrder(boolean outOfOrder) {
        this.configuration.setOutOfOrder(outOfOrder);
    }

    @Override
    public Callback[] getCallbacks() {
        return this.configuration.getCallbacks();
    }

    @Override
    public boolean isSkipDefaultCallbacks() {
        return this.configuration.isSkipDefaultCallbacks();
    }

    public void setCallbacks(Callback ... callbacks) {
        this.configuration.setCallbacks(callbacks);
    }

    @Deprecated
    public void setCallbacks(FlywayCallback ... callbacks) {
        LOG.warn("Flyway.setCallbacks(FlywayCallback) has been deprecated and will be removed in Flyway 6.0. Use Flyway.setCallbacks(Callback) instead.");
        ArrayList<LegacyCallback> l = new ArrayList<LegacyCallback>();
        for (FlywayCallback callback : callbacks) {
            l.add(new LegacyCallback(callback));
        }
        this.configuration.setCallbacks(l.toArray(new Callback[0]));
    }

    public void setCallbacksAsClassNames(String ... callbacks) {
        this.configuration.setCallbacksAsClassNames(callbacks);
    }

    public void setSkipDefaultCallbacks(boolean skipDefaultCallbacks) {
        this.configuration.setSkipDefaultCallbacks(skipDefaultCallbacks);
    }

    public void setResolvers(MigrationResolver ... resolvers) {
        this.configuration.setResolvers(resolvers);
    }

    public void setResolversAsClassNames(String ... resolvers) {
        this.configuration.setResolversAsClassNames(resolvers);
    }

    public void setSkipDefaultResolvers(boolean skipDefaultResolvers) {
        this.configuration.setSkipDefaultResolvers(skipDefaultResolvers);
    }

    public void setStream(boolean stream) {
        this.configuration.setStream(stream);
    }

    public void setBatch(boolean batch) {
        this.configuration.setBatch(batch);
    }

    public void setOracleSqlplus(boolean oracleSqlplus) {
        this.configuration.setOracleSqlplus(oracleSqlplus);
    }

    public int migrate() throws FlywayException {
        return this.execute(new Command<Integer>(){

            @Override
            public Integer execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor) {
                if (Flyway.this.configuration.isValidateOnMigrate()) {
                    Flyway.this.doValidate(database, migrationResolver, schemaHistory, schemas, callbackExecutor, true);
                }
                new DbSchemas(database, schemas, schemaHistory).create();
                if (!schemaHistory.exists()) {
                    ArrayList<Schema> nonEmptySchemas = new ArrayList<Schema>();
                    for (Schema schema : schemas) {
                        if (schema.empty()) continue;
                        nonEmptySchemas.add(schema);
                    }
                    if (!nonEmptySchemas.isEmpty()) {
                        if (Flyway.this.configuration.isBaselineOnMigrate()) {
                            Flyway.this.doBaseline(schemaHistory, database, schemas, callbackExecutor);
                        } else if (!schemaHistory.exists()) {
                            throw new FlywayException("Found non-empty schema(s) " + StringUtils.collectionToCommaDelimitedString(nonEmptySchemas) + " without schema history table! Use baseline() or set baselineOnMigrate to true to initialize the schema history table.");
                        }
                    }
                }
                return new DbMigrate(database, schemaHistory, schemas[0], migrationResolver, Flyway.this.configuration, callbackExecutor).migrate();
            }
        });
    }

    private void doBaseline(SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor) {
        new DbBaseline(database, schemaHistory, schemas[0], this.configuration.getBaselineVersion(), this.configuration.getBaselineDescription(), callbackExecutor).baseline();
    }

    public int undo() throws FlywayException {
        throw new FlywayProUpgradeRequiredException("undo");
    }

    public void validate() throws FlywayException {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor) {
                Flyway.this.doValidate(database, migrationResolver, schemaHistory, schemas, callbackExecutor, false);
                return null;
            }
        });
    }

    private void doValidate(Database database, MigrationResolver migrationResolver, SchemaHistory schemaHistory, Schema[] schemas, CallbackExecutor callbackExecutor, boolean pending) {
        String validationError = new DbValidate(database, schemaHistory, schemas[0], migrationResolver, this.configuration.getTarget(), this.configuration.isOutOfOrder(), pending, this.configuration.isIgnoreMissingMigrations(), this.configuration.isIgnoreIgnoredMigrations(), this.configuration.isIgnoreFutureMigrations(), callbackExecutor).validate();
        if (validationError != null) {
            if (this.configuration.isCleanOnValidationError()) {
                this.doClean(database, schemaHistory, schemas, callbackExecutor);
            } else {
                throw new FlywayException("Validate failed: " + validationError);
            }
        }
    }

    private void doClean(Database database, SchemaHistory schemaHistory, Schema[] schemas, CallbackExecutor callbackExecutor) {
        new DbClean(database, schemaHistory, schemas, callbackExecutor, this.configuration.isCleanDisabled()).clean();
    }

    public void clean() {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor) {
                Flyway.this.doClean(database, schemaHistory, schemas, callbackExecutor);
                return null;
            }
        });
    }

    public MigrationInfoService info() {
        return this.execute(new Command<MigrationInfoService>(){

            @Override
            public MigrationInfoService execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor) {
                return new DbInfo(migrationResolver, schemaHistory, Flyway.this.configuration, callbackExecutor).info();
            }
        });
    }

    public void baseline() throws FlywayException {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor) {
                new DbSchemas(database, schemas, schemaHistory).create();
                Flyway.this.doBaseline(schemaHistory, database, schemas, callbackExecutor);
                return null;
            }
        });
    }

    public void repair() throws FlywayException {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor) {
                new DbRepair(database, migrationResolver, schemaHistory, callbackExecutor).repair();
                return null;
            }
        });
    }

    private MigrationResolver createMigrationResolver(Database database, Scanner scanner, PlaceholderReplacer placeholderReplacer) {
        for (MigrationResolver resolver : this.configuration.getResolvers()) {
            ConfigUtils.injectFlywayConfiguration(resolver, this.configuration);
        }
        return new CompositeMigrationResolver(database, scanner, this.configuration, Arrays.asList(this.configuration.getLocations()), placeholderReplacer, this.configuration.getResolvers());
    }

    private PlaceholderReplacer createPlaceholderReplacer() {
        if (this.configuration.isPlaceholderReplacement()) {
            return new DefaultPlaceholderReplacer(this.configuration.getPlaceholders(), this.configuration.getPlaceholderPrefix(), this.configuration.getPlaceholderSuffix());
        }
        return NoopPlaceholderReplacer.INSTANCE;
    }

    public void configure(Properties properties) {
        this.configure(ConfigUtils.propertiesToMap(properties));
    }

    public void configure(Map<String, String> props) {
        this.configuration.configure(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T execute(Command<T> command) {
        T result;
        VersionPrinter.printVersion();
        if (this.configuration.getDataSource() == null) {
            throw new FlywayException("Unable to connect to the database. Configure the url, user and password!");
        }
        try (Database database = null;){
            database = DatabaseFactory.createDatabase(this.configuration, !this.dbConnectionInfoPrinted);
            this.dbConnectionInfoPrinted = true;
            LOG.debug("DDL Transactions Supported: " + database.supportsDdlTransactions());
            Schema[] schemas = this.prepareSchemas(database);
            Scanner scanner = new Scanner(this.configuration);
            PlaceholderReplacer placeholderReplacer = this.createPlaceholderReplacer();
            result = command.execute(this.createMigrationResolver(database, scanner, placeholderReplacer), SchemaHistoryFactory.getSchemaHistory(this.configuration, database, schemas[0]), database, schemas, new CallbackExecutor(this.configuration, database, schemas[0], this.prepareCallbacks(database, scanner, placeholderReplacer)));
        }
        return result;
    }

    private Schema[] prepareSchemas(Database database) {
        Object[] schemaNames = this.configuration.getSchemas();
        if (schemaNames.length == 0) {
            Schema currentSchema = ((Connection)database.getMainConnection()).getCurrentSchema();
            if (currentSchema == null) {
                throw new FlywayException("Unable to determine schema for the schema history table. Set a default schema for the connection or specify one using the schemas property!");
            }
            schemaNames = new String[]{currentSchema.getName()};
        }
        if (schemaNames.length == 1) {
            LOG.debug("Schema: " + (String)schemaNames[0]);
        } else {
            LOG.debug("Schemas: " + StringUtils.arrayToCommaDelimitedString(schemaNames));
        }
        Schema[] schemas = new Schema[schemaNames.length];
        for (int i = 0; i < schemaNames.length; ++i) {
            schemas[i] = ((Connection)database.getMainConnection()).getSchema((String)schemaNames[i]);
        }
        return schemas;
    }

    private List<Callback> prepareCallbacks(Database database, Scanner scanner, PlaceholderReplacer placeholderReplacer) {
        ArrayList<Callback> effectiveCallbacks = new ArrayList<Callback>();
        effectiveCallbacks.addAll(Arrays.asList(this.configuration.getCallbacks()));
        if (!this.configuration.isSkipDefaultCallbacks()) {
            effectiveCallbacks.addAll(new SqlScriptFlywayCallbackFactory(database, scanner, Arrays.asList(this.configuration.getLocations()), placeholderReplacer, this.configuration).getCallbacks());
        }
        for (Callback callback : effectiveCallbacks) {
            if (!(callback instanceof LegacyCallback)) continue;
            ConfigUtils.injectFlywayConfiguration(callback, this.configuration);
        }
        return effectiveCallbacks;
    }

    static interface Command<T> {
        public T execute(MigrationResolver var1, SchemaHistory var2, Database var3, Schema[] var4, CallbackExecutor var5);
    }
}

