/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.shell;

import com.oracle.truffle.js.shell.ConsoleHandler;
import com.oracle.truffle.js.shell.DefaultConsoleHandler;
import com.oracle.truffle.js.shell.JLineConsoleHandler;
import com.oracle.truffle.js.shell.JSFuzzilliRunner;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.graalvm.launcher.AbstractLanguageLauncher;
import org.graalvm.launcher.Launcher;
import org.graalvm.options.OptionCategory;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public class JSLauncher
extends AbstractLanguageLauncher {
    static final String MODULE_MIME_TYPE = "application/javascript+module";
    private static final String PROMPT = "> ";
    private boolean printResult = false;
    private boolean fuzzilliREPRL = false;
    private boolean allowExperimentalOptions = false;
    private boolean useSharedEngine = false;
    private String[] programArgs;
    private final List<UnparsedSource> unparsedSources = new LinkedList<UnparsedSource>();
    private Launcher.VersionAction versionAction = Launcher.VersionAction.None;
    private Map<String, String> enginePolyglotOptions;

    public static void main(String[] args) {
        new JSLauncher().launch(args);
    }

    protected void launch(Context.Builder contextBuilder) {
        int exitCode = this.fuzzilliREPRL ? JSFuzzilliRunner.runFuzzilliREPRL(contextBuilder) : this.executeScripts(contextBuilder);
        if (exitCode != 0) {
            throw this.abort(null, exitCode);
        }
    }

    protected String getLanguageId() {
        return "js";
    }

    protected void preEval(Context context) {
    }

    protected List<String> preprocessArguments(List<String> arguments, Map<String, String> polyglotOptions) {
        ArrayList<String> unrecognizedOptions = new ArrayList<String>();
        ListIterator<String> iterator = arguments.listIterator();
        block8: while (iterator.hasNext()) {
            String arg = iterator.next();
            if (arg.length() >= 2 && arg.startsWith("-")) {
                String value;
                String flag;
                if (arg.equals("--")) break;
                this.interceptExperimentalOptions(arg);
                if (arg.startsWith("--")) {
                    flag = arg.substring(2);
                } else {
                    String longFlag;
                    flag = arg.substring(1);
                    if (flag.length() == 1 && (longFlag = this.expandShortFlag(flag.charAt(0))) != null) {
                        flag = longFlag;
                    }
                }
                switch (this.preprocessArgument(flag)) {
                    case Consumed: {
                        continue block8;
                    }
                    case MissingValue: {
                        throw new RuntimeException("Should not reach here");
                    }
                }
                int equalsIndex = flag.indexOf(61);
                if (equalsIndex > 0) {
                    value = flag.substring(equalsIndex + 1);
                    flag = flag.substring(0, equalsIndex);
                } else {
                    value = iterator.hasNext() ? iterator.next() : null;
                }
                switch (this.preprocessArgument(flag, value)) {
                    case Consumed: {
                        continue block8;
                    }
                    case MissingValue: {
                        throw this.abort("Missing argument for " + arg);
                    }
                }
                unrecognizedOptions.add(arg);
                if (equalsIndex >= 0 || value == null) continue;
                iterator.previous();
                continue;
            }
            this.addFile(arg);
        }
        List<String> programArgsList = arguments.subList(iterator.nextIndex(), arguments.size());
        this.programArgs = programArgsList.toArray(new String[programArgsList.size()]);
        return unrecognizedOptions;
    }

    private void interceptExperimentalOptions(String arg) {
        switch (arg) {
            case "--experimental-options": 
            case "--experimental-options=true": {
                this.allowExperimentalOptions = true;
                break;
            }
            case "--experimental-options=false": {
                this.allowExperimentalOptions = false;
            }
        }
    }

    protected PreprocessResult preprocessArgument(String argument) {
        switch (argument) {
            case "print-result": {
                this.printResult = true;
                return PreprocessResult.Consumed;
            }
            case "show-version": {
                this.versionAction = Launcher.VersionAction.PrintAndContinue;
                return PreprocessResult.Consumed;
            }
            case "version": {
                this.versionAction = Launcher.VersionAction.PrintAndExit;
                return PreprocessResult.Consumed;
            }
            case "fuzzilli-reprl": {
                this.fuzzilliREPRL = true;
                return PreprocessResult.Consumed;
            }
            case "shared-engine": {
                this.useSharedEngine = true;
                return PreprocessResult.Consumed;
            }
        }
        return PreprocessResult.Unhandled;
    }

    protected PreprocessResult preprocessArgument(String argument, String value) {
        switch (argument) {
            case "eval": {
                if (value == null) {
                    return PreprocessResult.MissingValue;
                }
                this.addEval(value);
                return PreprocessResult.Consumed;
            }
            case "file": {
                if (value == null) {
                    return PreprocessResult.MissingValue;
                }
                this.addFile(value);
                return PreprocessResult.Consumed;
            }
            case "module": {
                if (value == null) {
                    return PreprocessResult.MissingValue;
                }
                this.addModule(value);
                return PreprocessResult.Consumed;
            }
            case "strict-file": {
                if (value == null) {
                    return PreprocessResult.MissingValue;
                }
                this.addStrictFile(value);
                return PreprocessResult.Consumed;
            }
        }
        return PreprocessResult.Unhandled;
    }

    protected String expandShortFlag(char f) {
        switch (f) {
            case 'e': {
                return "eval";
            }
            case 'f': {
                return "file";
            }
        }
        return null;
    }

    boolean hasSources() {
        return this.unparsedSources.size() > 0;
    }

    Source[] parseSources() {
        Source[] sources = new Source[this.unparsedSources.size()];
        int i = 0;
        for (UnparsedSource unparsedSource : this.unparsedSources) {
            try {
                sources[i++] = unparsedSource.parse();
            }
            catch (IOException e) {
                System.err.println(String.format("Error: Could not find or load file %s.", unparsedSource.src));
                return new Source[0];
            }
        }
        return sources;
    }

    void addFile(String file) {
        this.unparsedSources.add(new UnparsedSource(file, SourceType.FILE));
    }

    void addEval(String str) {
        this.unparsedSources.add(new UnparsedSource(str, SourceType.EVAL));
    }

    void addModule(String file) {
        this.unparsedSources.add(new UnparsedSource(file, SourceType.MODULE));
    }

    void addStrictFile(String file) {
        this.unparsedSources.add(new UnparsedSource(file, SourceType.STRICT));
    }

    protected void validateArguments(Map<String, String> polyglotOptions) {
        if (!this.hasSources() && this.printResult) {
            throw this.abort("Error: cannot print the return value when no FILE is passed.", 6);
        }
        if (this.useSharedEngine) {
            this.enginePolyglotOptions = new HashMap<String, String>(polyglotOptions);
            polyglotOptions.clear();
        }
    }

    protected void printHelp(OptionCategory maxCategory) {
        System.out.println();
        System.out.println("Usage: js [OPTION]... [FILE]...");
        System.out.println("Run JavaScript FILEs on the Graal.js engine. Run an interactive JavaScript shell if no FILE nor --eval is specified.\n");
        System.out.println("Arguments that are mandatory for long options are also mandatory for short options.\n");
        System.out.println("Basic Options:");
        JSLauncher.printOption("-e, --eval CODE", "evaluate the code");
        JSLauncher.printOption("-f, --file FILE", "load script file");
        JSLauncher.printOption("--module FILE", "load module file");
        JSLauncher.printOption("--script-file FILE", "load script file in strict mode");
        JSLauncher.printOption("--print-result", "print the return value of each FILE");
        JSLauncher.printOption("--version", "print the version and exit");
        JSLauncher.printOption("--show-version", "print the version and continue");
        JSLauncher.printOption("--shared-engine", "run in shared polyglot engine mode");
    }

    protected void collectArguments(Set<String> args) {
        args.addAll(Arrays.asList("-e", "--eval", "-f", "--file", "--module", "--strict-file", "--print-result", "--version", "--show-version", "--shared-engine"));
    }

    protected static void printOption(String option, String description) {
        String opt;
        if (option.length() >= 22) {
            System.out.println(String.format("%s%s", "  ", option));
            opt = "";
        } else {
            opt = option;
        }
        System.out.println(String.format("  %-22s%s", opt, description));
    }

    protected int executeScripts(Context.Builder contextBuilder) {
        int status;
        contextBuilder.arguments("js", this.programArgs);
        contextBuilder.option("js.shell", "true");
        contextBuilder.useSystemExit(true);
        Engine sharedEngine = null;
        if (this.useSharedEngine) {
            sharedEngine = Engine.newBuilder().allowExperimentalOptions(this.allowExperimentalOptions).options(this.enginePolyglotOptions).build();
            contextBuilder.engine(sharedEngine);
        }
        try (Engine engine = sharedEngine;
             Context context = contextBuilder.build();){
            this.runVersionAction(this.versionAction, context.getEngine());
            this.preEval(context);
            if (this.hasSources()) {
                Source[] sources = this.parseSources();
                status = -1;
                for (Source source : sources) {
                    try {
                        Value result = context.eval(source);
                        if (this.printResult) {
                            System.out.println("Result: " + result.toString());
                        }
                        status = 0;
                    }
                    catch (PolyglotException e) {
                        status = JSLauncher.handlePolyglotException(e);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        status = 8;
                    }
                }
            } else {
                status = JSLauncher.runREPL(context);
            }
        }
        catch (PolyglotException e) {
            status = JSLauncher.handlePolyglotException(e);
        }
        System.out.flush();
        System.err.flush();
        return status;
    }

    private static int handlePolyglotException(PolyglotException e) {
        int status;
        if (e.isExit()) {
            status = e.getExitStatus();
            if (status != 0) {
                JSLauncher.printError(e, System.err);
            }
        } else if (e.isSyntaxError()) {
            JSLauncher.printError(e, System.err);
            status = 7;
        } else if (!e.isInternalError()) {
            JSLauncher.printStackTraceSkipTrailingHost(e, System.err);
            status = 7;
        } else {
            e.printStackTrace();
            status = 8;
        }
        return status;
    }

    private static int runREPL(Context context) {
        ConsoleHandler console;
        try {
            console = JSLauncher.setupConsole();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return 1;
        }
        int lineNumber = 0;
        while (true) {
            try {
                while (true) {
                    String line;
                    if ((line = console.readLine()) == null) {
                        return 0;
                    }
                    if (line.equals("")) continue;
                    context.eval(Source.newBuilder((String)"js", (CharSequence)line, (String)("<shell>:" + ++lineNumber)).interactive(true).build());
                }
            }
            catch (PolyglotException e) {
                if (e.isExit()) {
                    return e.getExitStatus();
                }
                if (e.isSyntaxError()) {
                    JSLauncher.printError(e, System.err);
                    continue;
                }
                if (!e.isInternalError()) {
                    JSLauncher.printStackTraceSkipTrailingHost(e, System.err);
                    continue;
                }
                e.printStackTrace();
                return 8;
            }
            catch (Throwable t) {
                t.printStackTrace();
                return 8;
            }
            break;
        }
    }

    private static boolean isInteractiveTerminal() {
        return System.console() != null;
    }

    private static ConsoleHandler setupConsole() throws IOException {
        if (JSLauncher.isInteractiveTerminal()) {
            return new JLineConsoleHandler(System.in, System.out, PROMPT);
        }
        return new DefaultConsoleHandler(System.in, System.out, null);
    }

    private static void printError(Throwable e, PrintStream output) {
        String message = e.getMessage();
        if (message != null && !message.isEmpty()) {
            output.println(message);
        }
    }

    private static void printStackTraceSkipTrailingHost(PolyglotException e, PrintStream output) {
        PolyglotException.StackFrame s2;
        ArrayList<PolyglotException.StackFrame> stackTrace = new ArrayList<PolyglotException.StackFrame>();
        for (PolyglotException.StackFrame s2 : e.getPolyglotStackTrace()) {
            stackTrace.add(s2);
        }
        ListIterator iterator = stackTrace.listIterator(stackTrace.size());
        while (iterator.hasPrevious() && (s2 = (PolyglotException.StackFrame)iterator.previous()).isHostFrame()) {
            iterator.remove();
        }
        output.println(e.isHostException() ? e.asHostException().toString() : e.getMessage());
        for (PolyglotException.StackFrame s2 : stackTrace) {
            output.println("\tat " + s2);
        }
    }

    public static enum PreprocessResult {
        Consumed,
        Unhandled,
        MissingValue;

    }

    private static final class UnparsedSource {
        private final String src;
        private final SourceType type;
        private Source parsedSource;

        private UnparsedSource(String src, SourceType type) {
            this.src = src;
            this.type = type;
        }

        private Source parse() throws IOException {
            Source source = this.parsedSource;
            if (source == null) {
                source = this.parsedSource = this.parseImpl();
            }
            return source;
        }

        private Source parseImpl() throws IOException {
            switch (this.type) {
                case FILE: {
                    return Source.newBuilder((String)"js", (File)new File(this.src)).build();
                }
                case EVAL: {
                    return Source.newBuilder((String)"js", (CharSequence)this.src, (String)"<eval_script>").buildLiteral();
                }
                case MODULE: {
                    return Source.newBuilder((String)"js", (File)new File(this.src)).mimeType(JSLauncher.MODULE_MIME_TYPE).build();
                }
                case STRICT: {
                    return Source.newBuilder((String)"js", (File)new File(this.src)).content("\"use strict\";" + new String(Files.readAllBytes(Paths.get(this.src, new String[0])), StandardCharsets.UTF_8)).build();
                }
            }
            throw new IllegalStateException();
        }
    }

    private static enum SourceType {
        FILE,
        EVAL,
        MODULE,
        STRICT;

    }
}

