/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.profiler.impl;

import com.oracle.truffle.api.Option;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.tools.profiler.HeapMonitor;
import com.oracle.truffle.tools.profiler.impl.HeapMonitorInstrumentOptionDescriptors;
import com.oracle.truffle.tools.profiler.impl.ProfilerToolFactory;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Instrument;

@TruffleInstrument.Registration(id="heapmonitor", name="Heap Allocation Monitor", version="0.1.0", services={HeapMonitor.class})
public class HeapMonitorInstrument
extends TruffleInstrument {
    public static final String ID = "heapmonitor";
    static final String VERSION = "0.1.0";
    private HeapMonitor monitor;
    private static ProfilerToolFactory<HeapMonitor> factory;
    @Option(name="", help="Start the heap allocation monitor with the application. This produces no output but improves the precision of the data provided to third party tools.", category=OptionCategory.USER)
    static final OptionKey<Boolean> ENABLED;

    public static void setFactory(ProfilerToolFactory<HeapMonitor> factory) {
        if (factory == null || !factory.getClass().getName().startsWith("com.oracle.truffle.tools.profiler")) {
            throw new IllegalArgumentException("Wrong factory: " + factory);
        }
        HeapMonitorInstrument.factory = factory;
    }

    public static HeapMonitor getMonitor(Engine engine) {
        Instrument instrument = (Instrument)engine.getInstruments().get(ID);
        if (instrument == null) {
            throw new IllegalStateException("Heap Monitor is not installed.");
        }
        return (HeapMonitor)instrument.lookup(HeapMonitor.class);
    }

    protected void onCreate(TruffleInstrument.Env env) {
        this.monitor = factory.create(env);
        if (((Boolean)env.getOptions().get(ENABLED)).booleanValue()) {
            this.monitor.setCollecting(true);
        }
        env.registerService((Object)this.monitor);
    }

    protected OptionDescriptors getOptionDescriptors() {
        return new HeapMonitorInstrumentOptionDescriptors();
    }

    protected void onDispose(TruffleInstrument.Env env) {
        this.monitor.close();
    }

    static {
        try {
            Class.forName(HeapMonitor.class.getName(), true, HeapMonitor.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new AssertionError();
        }
        ENABLED = new OptionKey((Object)false);
    }
}

