/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import org.hyperledger.fabric.gateway.Wallet;
import org.hyperledger.fabric.gateway.impl.identity.CloudantWalletStore;
import org.hyperledger.fabric.gateway.impl.identity.FileSystemWalletStore;
import org.hyperledger.fabric.gateway.impl.identity.InMemoryWalletStore;
import org.hyperledger.fabric.gateway.impl.identity.WalletImpl;
import org.hyperledger.fabric.gateway.spi.WalletStore;

public final class Wallets {
    public static Wallet newInMemoryWallet() {
        InMemoryWalletStore store = new InMemoryWalletStore();
        return Wallets.newWallet(store);
    }

    public static Wallet newFileSystemWallet(Path storeDirectory) throws IOException {
        FileSystemWalletStore store = new FileSystemWalletStore(storeDirectory);
        return Wallets.newWallet(store);
    }

    public static Wallet newCouchDBWallet(URL serverUrl, String databaseName) {
        CloudantWalletStore store = CloudantWalletStore.newInstance(serverUrl, databaseName);
        return Wallets.newWallet(store);
    }

    public static Wallet newWallet(WalletStore store) {
        return new WalletImpl(store);
    }

    private Wallets() {
    }
}

