/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl.identity;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hyperledger.fabric.gateway.impl.GatewayUtils;
import org.hyperledger.fabric.gateway.spi.WalletStore;

public final class InMemoryWalletStore
implements WalletStore {
    private final Map<String, byte[]> store = new HashMap<String, byte[]>();

    @Override
    public void remove(String label) {
        this.store.remove(label);
    }

    @Override
    public InputStream get(String label) {
        byte[] data = this.store.get(label);
        return data != null ? new ByteArrayInputStream(data) : null;
    }

    @Override
    public Set<String> list() {
        return this.store.keySet();
    }

    @Override
    public void put(String label, InputStream data) throws IOException {
        try (BufferedInputStream bufferedInput = new BufferedInputStream(data);
             ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();){
            GatewayUtils.copy(bufferedInput, byteOutput);
            this.store.put(label, byteOutput.toByteArray());
        }
    }
}

