/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.dataexporter;

import com.icesoft.faces.application.D2DViewHandler;
import com.icesoft.faces.component.dataexporter.CSVOutputHandler;
import com.icesoft.faces.component.dataexporter.ExcelOutputHandler;
import com.icesoft.faces.component.dataexporter.OutputTypeHandler;
import com.icesoft.faces.component.ext.UIColumn;
import com.icesoft.faces.component.outputresource.OutputResource;
import com.icesoft.faces.context.FileResource;
import com.icesoft.faces.context.Resource;
import com.icesoft.faces.context.effects.JavascriptContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;

public class DataExporter
extends OutputResource {
    public static final String COMPONENT_FAMILY = "com.icesoft.faces.DataExporter";
    public static final String COMPONENT_TYPE = "com.icesoft.faces.DataExporter";
    public static final String DEFAULT_RENDERER_TYPE = "com.icesoft.faces.DataExporterRenderer";
    private boolean readyToExport = false;
    private String _for;
    private String type;
    private String clickToCreateFileText;
    private String _origType;
    private transient OutputTypeHandler outputTypeHandler;
    private String _origFor;
    private transient OutputTypeHandler _origOutputTypeHandler;
    private transient int _origDataModelHash = 0;
    public static final String EXCEL_TYPE = "excel";
    public static final String CSV_TYPE = "csv";
    private transient Object[] values;

    public String getFamily() {
        return "com.icesoft.faces.DataExporter";
    }

    public String getComponentType() {
        return "com.icesoft.faces.DataExporter";
    }

    public String getRendererType() {
        return DEFAULT_RENDERER_TYPE;
    }

    public UIData getUIData() {
        String forStr = this.getFor();
        UIData forComp = (UIData)D2DViewHandler.findComponent((String)forStr, (UIComponent)this);
        if (forComp == null) {
            throw new IllegalArgumentException("could not find UIData referenced by attribute @for = '" + forStr + "'");
        }
        if (!(forComp instanceof UIData)) {
            throw new IllegalArgumentException("uiComponent referenced by attribute @for = '" + forStr + "' must be of type " + UIData.class.getName() + ", not type " + forComp.getClass().getName());
        }
        if (this._origDataModelHash != 0 && this._origDataModelHash != forComp.getValue().hashCode()) {
            this.reset();
        }
        this._origDataModelHash = forComp.getValue().hashCode();
        return forComp;
    }

    private void reset() {
        this.readyToExport = false;
        this.resource = null;
    }

    public String getFor() {
        if (this._for != null) {
            if (!this._for.equals(this._origFor)) {
                this.reset();
            }
            this._origFor = this._for;
            return this._for;
        }
        ValueBinding vb = this.getValueBinding("for");
        String newFor = null;
        if (vb != null) {
            newFor = (String)vb.getValue(this.getFacesContext());
            if (newFor != null && !newFor.equals(this._origFor)) {
                this.reset();
            }
            this._origFor = newFor;
        }
        return newFor;
    }

    public void setFor(String forValue) {
        if (forValue != null && !forValue.equals(this._for)) {
            this.resource = null;
        }
        this._for = forValue;
    }

    public String getType() {
        if (this.type != null) {
            if (!this.type.equals(this._origType)) {
                this.reset();
            }
            this._origType = this.type;
            return this.type;
        }
        ValueBinding vb = this.getValueBinding("type");
        String newType = null;
        if (vb != null) {
            newType = (String)vb.getValue(this.getFacesContext());
            if (newType != null && !newType.equals(this._origType)) {
                this.reset();
            }
            this._origType = newType;
        }
        return newType;
    }

    public void setType(String type) {
        if (type != null && !type.equals(this.type)) {
            this.reset();
        }
        this.type = type;
    }

    public boolean isReadyToExport() {
        return this.readyToExport;
    }

    public void setReadyToExport(boolean readyToExport) {
        this.readyToExport = readyToExport;
    }

    public String getClickToCreateFileText() {
        if (this.clickToCreateFileText != null) {
            return this.clickToCreateFileText;
        }
        ValueBinding vb = this.getValueBinding("clickToCreateFileText");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setClickToCreateFileText(String clickToCreateFileText) {
        this.clickToCreateFileText = clickToCreateFileText;
    }

    public OutputTypeHandler getOutputTypeHandler() {
        ValueBinding vb = this.getValueBinding("outputTypeHandler");
        OutputTypeHandler newOutputHandler = null;
        if (vb != null) {
            newOutputHandler = (OutputTypeHandler)vb.getValue(this.getFacesContext());
            if (newOutputHandler != null && newOutputHandler != this._origOutputTypeHandler) {
                this.reset();
            }
            this._origOutputTypeHandler = newOutputHandler;
        }
        return newOutputHandler;
    }

    public void setOutputTypeHandler(OutputTypeHandler outputTypeHandler) {
        if (outputTypeHandler != null && outputTypeHandler != this.outputTypeHandler) {
            this.reset();
        }
        this.outputTypeHandler = outputTypeHandler;
    }

    public Object saveState(FacesContext context) {
        if (this.values == null) {
            this.values = new Object[7];
        }
        this.values[0] = super.saveState(context);
        this.values[1] = this._for;
        this.values[2] = this.type;
        this.values[3] = this.clickToCreateFileText;
        this.values[4] = this.readyToExport ? Boolean.TRUE : Boolean.FALSE;
        this.values[5] = this._origType;
        this.values[6] = this._origFor;
        return this.values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._for = (String)values[1];
        this.type = (String)values[2];
        this.clickToCreateFileText = (String)values[3];
        this.readyToExport = (Boolean)values[4];
        this._origType = (String)values[5];
        this._origFor = (String)values[6];
    }

    public String getLabel() {
        String label = super.getLabel();
        if (label == null && this.resource instanceof FileResource) {
            label = ((FileResource)this.resource).getFile().getName();
        }
        return label;
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event != null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            String type = this.getType();
            Resource res = this.getResource();
            if (res == null) {
                File output = this.createFile(facesContext, type);
                this.setResource((Resource)new FileResource(output));
                this.getResource();
            }
            JavascriptContext.addJavascriptCall((FacesContext)facesContext, (String)("window.open('" + this.getPath() + "');"));
        }
    }

    private File createFile(FacesContext fc, String type) {
        UIData uiData = this.getUIData();
        OutputTypeHandler outputHandler = null;
        ServletContext context = ((HttpSession)FacesContext.getCurrentInstance().getExternalContext().getSession(false)).getServletContext();
        try {
            File exportDir = new File(context.getRealPath("/export"));
            if (!exportDir.exists()) {
                exportDir.mkdirs();
            }
            String pathWithoutExt = context.getRealPath("/export") + "/export_" + new Date().getTime();
            if (this.getOutputTypeHandler() != null) {
                outputHandler = this.getOutputTypeHandler();
            } else if (EXCEL_TYPE.equals(this.getType())) {
                outputHandler = new ExcelOutputHandler(pathWithoutExt + ".xls", fc, uiData.getId());
            } else if (CSV_TYPE.equals(this.getType())) {
                outputHandler = new CSVOutputHandler(pathWithoutExt + ".csv");
            }
            if (outputHandler == null) {
                return null;
            }
            this.renderToHandler(outputHandler, uiData, fc);
            this.setMimeType(outputHandler.getMimeType());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outputHandler != null ? outputHandler.getFile() : null;
    }

    private String encodeParentAndChildrenAsString(FacesContext fc, UIComponent uic, String str) {
        Object value = uic.getAttributes().get("value");
        if (value != null) {
            str = str + "" + value;
        } else {
            ValueBinding vb = uic.getValueBinding("value");
            if (vb != null) {
                str = str + String.valueOf(vb.getValue(fc));
            }
        }
        if (uic.getChildCount() > 0) {
            Iterator iter = uic.getChildren().iterator();
            while (iter.hasNext()) {
                UIComponent child = (UIComponent)iter.next();
                str = str + this.encodeParentAndChildrenAsString(fc, child, str);
            }
        }
        return str;
    }

    protected List getRenderedChildColumnsList(UIComponent component) {
        ArrayList<UIComponent> results = new ArrayList<UIComponent>();
        Iterator kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!(kid instanceof UIColumn) || !kid.isRendered()) continue;
            results.add(kid);
        }
        return results;
    }

    private void renderToHandler(OutputTypeHandler outputHandler, UIData uiData, FacesContext fc) {
        try {
            UIColumn nextColumn;
            int rowIndex = uiData.getFirst();
            int colIndex = 0;
            int numberOfRowsToDisplay = uiData.getRows();
            int countOfRowsDisplayed = 0;
            uiData.setRowIndex(rowIndex);
            Iterator childColumns = this.getRenderedChildColumnsList((UIComponent)uiData).iterator();
            while (childColumns.hasNext()) {
                nextColumn = (UIColumn)((Object)childColumns.next());
                UIComponent headerComp = nextColumn.getFacet("header");
                if (headerComp != null) {
                    String headerText = "";
                    if ((headerText = this.encodeParentAndChildrenAsString(fc, headerComp, headerText)) != null) {
                        outputHandler.writeHeaderCell(headerText, colIndex);
                    }
                }
                ++colIndex;
            }
            while (uiData.isRowAvailable() && (numberOfRowsToDisplay <= 0 || countOfRowsDisplayed < numberOfRowsToDisplay)) {
                childColumns = this.getRenderedChildColumnsList((UIComponent)uiData).iterator();
                colIndex = 0;
                while (childColumns.hasNext()) {
                    nextColumn = (UIColumn)((Object)childColumns.next());
                    String output = null;
                    String stringOutput = "";
                    Iterator childrenOfThisColumn = nextColumn.getChildren().iterator();
                    while (childrenOfThisColumn.hasNext()) {
                        UIComponent nextChild = (UIComponent)childrenOfThisColumn.next();
                        if (!nextChild.isRendered()) continue;
                        stringOutput = stringOutput + this.encodeParentAndChildrenAsString(fc, nextChild, stringOutput);
                    }
                    output = stringOutput;
                    outputHandler.writeCell(output, colIndex, rowIndex);
                    ++colIndex;
                }
                ++countOfRowsDisplayed;
                uiData.setRowIndex(++rowIndex);
            }
            uiData.setRowIndex(-1);
            outputHandler.flushFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

