/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.paneltooltip;

import com.icesoft.faces.application.D2DViewHandler;
import com.icesoft.faces.component.DisplayEvent;
import com.icesoft.faces.component.ext.HtmlPanelGroup;
import com.icesoft.faces.component.ext.taglib.Util;
import com.icesoft.faces.component.panelpopup.PanelPopup;
import com.icesoft.faces.component.paneltooltip.TooltipInfo;
import com.icesoft.faces.component.util.CustomComponentUtils;
import com.icesoft.faces.context.effects.CurrentStyle;
import com.icesoft.faces.context.effects.JavascriptContext;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import org.w3c.dom.Element;

public class PanelTooltip
extends PanelPopup {
    public static final String COMPONENT_TYPE = "com.icesoft.faces.PanelTooltip";
    public static final String DEFAULT_RENDERER_TYPE = "com.icesoft.faces.PanelTooltipRenderer";
    public static String ICE_TOOLTIP_INFO = "iceTooltipInfo";
    private Integer hoverDelay;
    private String hideOn;
    private transient UIComponent tooltipSrcComponent;
    private String styleClass = null;
    private MethodBinding displayListener;
    private transient Object[] states;

    public PanelTooltip() {
        this.setRendererType(DEFAULT_RENDERER_TYPE);
        JavascriptContext.includeLib((String)JavascriptContext.ICE_EXTRAS, (FacesContext)FacesContext.getCurrentInstance());
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        this.setValueChangeFired(false);
    }

    public int getHoverDelay() {
        if (this.hoverDelay != null) {
            return this.hoverDelay;
        }
        ValueBinding vb = this.getValueBinding("hoverDelay");
        return vb != null ? (Integer)vb.getValue(this.getFacesContext()) : 500;
    }

    public void setHoverDelay(int hoverDelay) {
        this.hoverDelay = new Integer(hoverDelay);
    }

    public String getHideOn() {
        if (this.hideOn != null) {
            return this.hideOn;
        }
        ValueBinding vb = this.getValueBinding("hideOn");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "mouseout";
    }

    public void setHideOn(String hideOn) {
        this.hideOn = hideOn;
    }

    public boolean isDynamic() {
        return this.isDraggable() || this.displayListener != null || this.getValueBinding("visible") != null;
    }

    public UIComponent getTooltipSrcComponent() {
        if (this.tooltipSrcComponent != null) {
            return this.tooltipSrcComponent;
        }
        ValueBinding vb = this.getValueBinding("tooltipSrcComponent");
        return vb != null ? (UIComponent)vb.getValue(this.getFacesContext()) : null;
    }

    public void setTooltipSrcComponent(UIComponent tooltipSrcComponent) {
        this.tooltipSrcComponent = tooltipSrcComponent;
    }

    public String getStyleClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.styleClass, "icePnlTlTip", "styleClass");
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public void updateModal(FacesContext context) {
        ValueBinding vb = this.getValueBinding("tooltipSrcComponent");
        if (vb != null) {
            vb.setValue(context, (Object)this.tooltipSrcComponent);
        }
    }

    public void processUpdates(FacesContext context) {
        ValueBinding vb = this.getValueBinding("visible");
        if (vb != null) {
            Map map = (Map)context.getExternalContext().getSessionMap().get(CurrentStyle.class.getName());
            if (this.isValueChangeFired() || map != null && map.containsKey(this.getClientId(context))) {
                vb.setValue(context, (Object)new Boolean("show".equals(this.getTooltipInfo().getState())));
            }
        }
        if (this.visible != null) {
            this.visible = new Boolean("show".equals(this.getTooltipInfo().getState()));
        }
        super.processUpdates(context);
    }

    public void applyStyle(FacesContext facesContext, Element root) {
        super.applyStyle(facesContext, root);
        String updatedStyle = root.getAttribute("style");
        if (this.isDynamic() && this.cssUpdateReceived(facesContext)) {
            String y = CustomComponentUtils.getCssPropertyValue(updatedStyle, "top");
            String x = CustomComponentUtils.getCssPropertyValue(updatedStyle, "left");
            if (y != null) {
                this.setTooltipY(y);
            }
            if (x != null) {
                this.setTooltipX(x);
            }
        }
        if (!this.isDynamic() && !this.isInitialized()) {
            updatedStyle = CustomComponentUtils.setPropertyValue(updatedStyle, "visibility", "hidden", true);
            updatedStyle = CustomComponentUtils.setPropertyValue(updatedStyle, "display", "none", true);
            this.setInitialized(true);
        }
        if (this.isDynamic()) {
            updatedStyle = CustomComponentUtils.setPropertyValue(updatedStyle, "position", "absolute", true);
        }
        if (this.isValueChangeFired() || this.isDynamic() && !this.cssUpdateReceived(facesContext)) {
            this.setValueChangeFired(false);
            if (this.getState().equals("show")) {
                updatedStyle = CustomComponentUtils.setPropertyValue(updatedStyle, "top", this.getTooltipY(), true);
                updatedStyle = CustomComponentUtils.setPropertyValue(updatedStyle, "left", this.getTooltipX(), true);
            }
        }
        root.setAttribute("style", updatedStyle);
    }

    void setInitialized(boolean initialized) {
        this.getAttributes().put("comp-initialized", String.valueOf(initialized));
    }

    boolean isInitialized() {
        return Boolean.getBoolean(String.valueOf(this.getAttributes().get("comp-initialized")));
    }

    private boolean cssUpdateReceived(FacesContext facesContext) {
        String clientId;
        Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
        if (requestMap == null || !requestMap.containsKey("icefacesCssUpdates")) {
            return false;
        }
        String CSS_UPDATE = String.valueOf(requestMap.get("icefacesCssUpdates"));
        return CSS_UPDATE.startsWith(clientId = this.getClientId(facesContext));
    }

    public void decode(FacesContext context) {
        super.decode(context);
    }

    public static void decodeTooltip(FacesContext facesContext, UIComponent target) {
        Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
        if (requestMap.containsKey(ICE_TOOLTIP_INFO)) {
            PanelTooltip.populateTooltipInfo(facesContext, target, String.valueOf(requestMap.get(ICE_TOOLTIP_INFO)));
        }
    }

    public static void populateTooltipInfo(FacesContext facesContext, UIComponent target, String tooltipinfo) {
        String tooltipId = ((HtmlPanelGroup)target).getPanelTooltip();
        String contextValue = String.valueOf(((HtmlPanelGroup)target).getContextValue());
        UIComponent tooltipComponent = D2DViewHandler.findComponent((String)tooltipId, (UIComponent)target);
        String tooltipClientId = tooltipComponent.getClientId(facesContext);
        String[] entries = tooltipinfo.split(";");
        if (entries.length == 6) {
            if (!entries[0].split("=")[1].equals(tooltipClientId)) {
                return;
            }
            TooltipInfo tooltipInfo = PanelTooltip.getTooltipInfo(tooltipComponent, tooltipClientId);
            tooltipInfo.populateValues(entries);
            if (entries[1].split("=")[1].equals(target.getClientId(facesContext))) {
                target.queueEvent((FacesEvent)new DisplayEvent(tooltipComponent, target, contextValue, "show".equalsIgnoreCase(tooltipInfo.getState())));
            }
        }
    }

    String getState() {
        ValueBinding vb = this.getValueBinding("state");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : this.getTooltipInfo().getState();
    }

    void setState(String state) {
        this.getTooltipInfo().setState(state);
    }

    String getTooltipSrcComp() {
        return this.getTooltipInfo().getSrc();
    }

    String getTooltipX() {
        return this.getTooltipInfo().getX();
    }

    String getTooltipY() {
        return this.getTooltipInfo().getY();
    }

    void setTooltipX(String x) {
        this.getTooltipInfo().setX(x);
    }

    void setTooltipY(String y) {
        this.getTooltipInfo().setY(y);
    }

    void setValueChangeFired(boolean eventFired) {
        this.getTooltipInfo().setEventFired(eventFired);
    }

    boolean isValueChangeFired() {
        return this.getTooltipInfo().isEventFired();
    }

    boolean isDraggable() {
        return "true".equalsIgnoreCase(this.getDraggable());
    }

    void removeTooltipFromVisibleList(FacesContext facesContext) {
        boolean oldValue = "show".equals(this.getTooltipInfo().getState());
        boolean show = this.isVisible();
        if (!show && oldValue) {
            this.setState(this.isVisible() ? "show" : "hide");
            JavascriptContext.addJavascriptCall((FacesContext)facesContext, (String)("ToolTipPanelPopupUtil.removeFromVisibleList('" + this.getClientId(facesContext) + "');"));
        }
    }

    public static TooltipInfo getTooltipInfo(UIComponent tooltipComponent, String tooltipClientId) {
        if (!tooltipComponent.getAttributes().containsKey("tooltip" + tooltipClientId)) {
            tooltipComponent.getAttributes().put("tooltip" + tooltipClientId, new TooltipInfo());
        }
        return (TooltipInfo)tooltipComponent.getAttributes().get("tooltip" + tooltipClientId);
    }

    TooltipInfo getTooltipInfo() {
        if (!this.getAttributes().containsKey("tooltip" + this.getClientId(this.getFacesContext()))) {
            this.getAttributes().put("tooltip" + this.getClientId(this.getFacesContext()), new TooltipInfo());
        }
        return (TooltipInfo)this.getAttributes().get("tooltip" + this.getClientId(this.getFacesContext()));
    }

    public MethodBinding getDisplayListener() {
        return this.displayListener;
    }

    public void setDisplayListener(MethodBinding displayListener) {
        this.displayListener = displayListener;
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (this.displayListener != null) {
            Object[] displayEvent = new Object[]{(DisplayEvent)event};
            this.displayListener.invoke(this.getFacesContext(), displayEvent);
        }
    }

    public boolean isVisible() {
        if (this.visible != null) {
            return this.visible;
        }
        ValueBinding vb = this.getValueBinding("visible");
        Boolean boolVal = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return boolVal != null ? boolVal.booleanValue() : "show".equals(this.getTooltipInfo().getState());
    }

    public void restoreState(FacesContext context, Object state) {
        this.states = (Object[])state;
        super.restoreState(context, this.states[0]);
        this.displayListener = (MethodBinding)PanelTooltip.restoreAttachedState((FacesContext)context, (Object)this.states[1]);
        this.styleClass = (String)this.states[2];
        this.hideOn = (String)this.states[3];
        this.hoverDelay = (Integer)this.states[4];
    }

    public Object saveState(FacesContext context) {
        if (this.states == null) {
            this.states = new Object[5];
        }
        this.states[0] = super.saveState(context);
        this.states[1] = PanelTooltip.saveAttachedState((FacesContext)context, (Object)this.displayListener);
        this.states[2] = this.styleClass;
        this.states[3] = this.hideOn;
        this.states[4] = this.hoverDelay;
        return this.states;
    }
}

