/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.swing;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.RenderedImage;
import javax.swing.JPanel;

public class SimpleImagePane
extends JPanel {
    private RenderedImage image;
    private AffineTransform imageToDisplay;
    private AffineTransform displayToImage;
    private int margin = 0;
    private final Object lock = new Object();

    public SimpleImagePane() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent ce) {
                SimpleImagePane.this.setTransform();
            }
        });
    }

    public void setImage(RenderedImage image) {
        this.image = image;
        this.setTransform();
        this.repaint();
    }

    public void clear() {
        this.image = null;
        this.repaint();
    }

    public void resetTransform() {
        this.setTransform();
    }

    public Point getImageCoords(Point paneCoords, Point imageCoords) {
        if (this.image != null) {
            Point2D p = this.displayToImage.transform(paneCoords, null);
            if (imageCoords != null) {
                imageCoords.x = (int)p.getX();
                imageCoords.y = (int)p.getY();
                return imageCoords;
            }
            return new Point((int)p.getX(), (int)p.getY());
        }
        return null;
    }

    public Point getPaneCoords(Point imageCoords, Point paneCoords) {
        if (this.image != null) {
            Point2D p = this.imageToDisplay.transform(imageCoords, null);
            if (paneCoords != null) {
                paneCoords.x = (int)p.getX();
                paneCoords.y = (int)p.getY();
                return paneCoords;
            }
            return new Point((int)p.getX(), (int)p.getY());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Object object = this.lock;
        synchronized (object) {
            if (this.image != null) {
                if (this.imageToDisplay == null) {
                    this.setTransform();
                }
                Graphics2D g2d = (Graphics2D)g;
                g2d.drawRenderedImage(this.image, this.imageToDisplay);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTransform() {
        Object object = this.lock;
        synchronized (object) {
            if (this.image != null) {
                Rectangle visr = this.getVisibleRect();
                if (visr.isEmpty()) {
                    return;
                }
                if (this.imageToDisplay == null) {
                    this.imageToDisplay = new AffineTransform();
                }
                double xscale = (visr.getWidth() - (double)(2 * this.margin)) / (double)this.image.getWidth();
                double yscale = (visr.getHeight() - (double)(2 * this.margin)) / (double)this.image.getHeight();
                double scale = Math.min(xscale, yscale);
                double xoff = (double)this.margin - scale * (double)this.image.getMinX();
                double yoff = (double)this.margin - scale * (double)this.image.getMinY();
                this.imageToDisplay.setTransform(scale, 0.0, 0.0, scale, xoff, yoff);
                try {
                    this.displayToImage = this.imageToDisplay.createInverse();
                }
                catch (NoninvertibleTransformException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }
}

