/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.util.LinkedList;
import java.util.List;
import org.jamon.api.Location;
import org.jamon.codegen.CodeWriter;
import org.jamon.codegen.FragmentUnit;
import org.jamon.codegen.GenericParams;
import org.jamon.codegen.LiteralStatement;
import org.jamon.codegen.Statement;
import org.jamon.codegen.StatementBlock;
import org.jamon.codegen.TemplateDescriber;
import org.jamon.codegen.Unit;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.node.ArgNode;
import org.jamon.node.FragmentArgsNode;
import org.jamon.node.OptionalArgNode;

public abstract class AbstractStatementBlock
implements StatementBlock {
    private final List<Statement> statements = new LinkedList<Statement>();
    private final StatementBlock parent;
    private final Location location;

    public AbstractStatementBlock(StatementBlock parent, Location location) {
        this.parent = parent;
        this.location = location;
    }

    protected void printStatements(CodeWriter writer, TemplateDescriber describer) throws ParserErrorImpl {
        for (Statement statement : this.getStatements()) {
            statement.generateSource(writer, describer);
        }
    }

    @Override
    public FragmentUnit getFragmentUnitIntf(String path) {
        return this.getParentUnit().getFragmentUnitIntf(path);
    }

    @Override
    public void addStatement(Statement statement) {
        if (statement instanceof LiteralStatement && !this.statements.isEmpty() && this.statements.get(this.statements.size() - 1) instanceof LiteralStatement) {
            ((LiteralStatement)this.statements.get(this.statements.size() - 1)).appendText(((LiteralStatement)statement).getText());
        } else {
            this.statements.add(statement);
        }
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public boolean doesIO() {
        return !this.statements.isEmpty();
    }

    @Override
    public FragmentUnit addFragment(FragmentArgsNode node, GenericParams genericParams) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addRequiredArg(ArgNode node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addOptionalArg(OptionalArgNode node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Unit getParentUnit() {
        return this.parent instanceof Unit ? (Unit)this.parent : this.parent.getParentUnit();
    }

    @Override
    public StatementBlock getParent() {
        return this.parent;
    }

    public Location getLocation() {
        return this.location;
    }
}

