/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.util.LinkedList;
import java.util.List;
import org.jamon.node.GenericsBoundNode;
import org.jamon.node.GenericsParamNode;

public class GenericParams {
    private final List<GenericsParamNode> genericsParamNodes = new LinkedList<GenericsParamNode>();

    public void addParam(GenericsParamNode node) {
        this.genericsParamNodes.add(node);
    }

    public String generateGenericsDeclaration() {
        return this.generateGenericsSpecifiers(true);
    }

    public String generateGenericParamsList() {
        return this.generateGenericsSpecifiers(false);
    }

    public int getCount() {
        return this.genericsParamNodes.size();
    }

    private String generateGenericsSpecifiers(boolean forDeclaration) {
        if (this.genericsParamNodes.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('<');
        boolean paramsPrinted = false;
        for (GenericsParamNode genericsParamNode : this.genericsParamNodes) {
            if (paramsPrinted) {
                builder.append(", ");
            } else {
                paramsPrinted = true;
            }
            builder.append(genericsParamNode.getName());
            if (!forDeclaration) continue;
            boolean boundsPrinted = false;
            for (GenericsBoundNode bound : genericsParamNode.getBounds()) {
                if (!boundsPrinted) {
                    builder.append(" extends ");
                    boundsPrinted = true;
                } else {
                    builder.append(" & ");
                }
                builder.append(bound.getClassName());
            }
        }
        builder.append('>');
        return builder.toString();
    }
}

