/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.io.IOException;
import java.io.OutputStream;
import org.jamon.codegen.AbstractArgument;
import org.jamon.codegen.AbstractSourceGenerator;
import org.jamon.codegen.AnnotationType;
import org.jamon.codegen.ArgNames;
import org.jamon.codegen.ClassNames;
import org.jamon.codegen.CodeWriter;
import org.jamon.codegen.DefUnit;
import org.jamon.codegen.FragmentArgument;
import org.jamon.codegen.FragmentUnit;
import org.jamon.codegen.MethodUnit;
import org.jamon.codegen.OptionalArgument;
import org.jamon.codegen.PathUtils;
import org.jamon.codegen.TemplateDescriber;
import org.jamon.codegen.TemplateUnit;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;

public class ImplGenerator
extends AbstractSourceGenerator {
    private static final String SET_OPTS = "__jamon_setOptionalArguments";

    public ImplGenerator(TemplateDescriber describer, TemplateUnit templateUnit) {
        super(describer, templateUnit);
    }

    public void generateSource(OutputStream out) throws IOException {
        this.writer = new CodeWriter(out, this.templateUnit.getEncoding());
        try {
            this.generateHeader();
            this.generatePrologue();
            this.generateImports();
            this.generateDeclaration();
            this.generateSetOptionalArguments();
            this.generateConstructor();
            this.generateRender();
            this.generateDefs();
            this.generateMethods();
            this.generateEpilogue();
            this.writer.finish();
        }
        catch (ParserErrorImpl e) {
            throw new ParserErrorsImpl(e);
        }
    }

    private final String getPath() {
        return this.templateUnit.getName();
    }

    private String getClassName() {
        return PathUtils.getImplClassName(this.getPath());
    }

    private void generateHeader() {
        this.writer.println("// Autogenerated Jamon implementation");
        this.writer.println("// " + this.describer.getExternalIdentifier(this.getPath()).replace('\\', '/'));
        this.writer.println();
    }

    private void generateDeclaration() {
        this.generateCustomAnnotations(this.templateUnit.getAnnotations(), AnnotationType.IMPL);
        this.writer.print("public");
        if (this.templateUnit.isParent()) {
            this.writer.print(" abstract");
        }
        this.writer.println(" class " + this.getClassName() + this.templateUnit.getGenericParams().generateGenericsDeclaration());
        this.writer.println("  extends " + (this.templateUnit.hasParentPath() ? PathUtils.getFullyQualifiedImplClassName(this.templateUnit.getParentPath()) : ClassNames.BASE_TEMPLATE));
        this.writer.println("  implements " + this.getProxyClassName() + ".Intf" + this.templateUnit.getGenericParams().generateGenericParamsList());
        this.writer.println();
        this.writer.openBlock();
        if (this.templateUnit.getJamonContextType() != null) {
            this.writer.println("protected final " + this.templateUnit.getJamonContextType() + " jamonContext;");
        }
        for (AbstractArgument arg : this.templateUnit.getVisibleArgs()) {
            this.writer.println("private final " + arg.getFullyQualifiedType() + " " + arg.getName() + ";");
        }
        this.templateUnit.printClassContent(this.writer);
    }

    private void generateSetOptionalArguments() {
        this.writer.println("protected static " + this.templateUnit.getGenericParams().generateGenericsDeclaration() + this.getImplDataClassName() + " " + SET_OPTS + "(" + this.getImplDataClassName() + " p_implData)");
        this.writer.openBlock();
        for (OptionalArgument arg : this.templateUnit.getSignatureOptionalArgs()) {
            String value = this.templateUnit.getOptionalArgDefault(arg);
            if (value == null) continue;
            this.writer.println("if(! p_implData." + arg.getIsNotDefaultName() + "())");
            this.writer.openBlock();
            this.writer.println("p_implData." + arg.getSetterName() + "(" + value + ");");
            this.writer.closeBlock();
        }
        if (this.templateUnit.hasParentPath()) {
            this.writer.println(this.getParentImplClassName() + "." + SET_OPTS + "(p_implData);");
        }
        this.writer.println("return p_implData;");
        this.writer.closeBlock();
    }

    private void generateConstructor() {
        this.writer.println("public " + this.getClassName() + "(" + ClassNames.TEMPLATE_MANAGER + " p_templateManager, " + this.getImplDataClassName() + " p_implData)");
        this.writer.openBlock();
        this.writer.println("super(p_templateManager, __jamon_setOptionalArguments(p_implData));");
        if (this.templateUnit.getJamonContextType() != null) {
            this.writer.println("jamonContext = p_implData.getJamonContext();");
        }
        for (AbstractArgument arg : this.templateUnit.getVisibleArgs()) {
            this.writer.println(arg.getName() + " = p_implData." + arg.getGetterName() + "();");
        }
        this.writer.closeBlock();
        this.writer.println();
    }

    private void generatePrologue() {
        String pkgName = PathUtils.getImplPackageName(this.getPath());
        if (pkgName.length() > 0) {
            this.writer.println("package " + pkgName + ";");
            this.writer.println();
        }
    }

    private void generateInnerUnitFargInterface(FragmentUnit fragmentUnit, boolean isPrivate) {
        this.writer.println();
        this.writer.printLocation(fragmentUnit.getLocation());
        fragmentUnit.printInterface(this.writer, isPrivate ? "private" : "protected", false);
    }

    private void generateDefs() throws ParserErrorImpl {
        for (DefUnit defUnit : this.templateUnit.getDefUnits()) {
            for (FragmentArgument frag : defUnit.getFragmentArgs()) {
                this.generateInnerUnitFargInterface(frag.getFragmentUnit(), true);
            }
            this.writer.println();
            this.writer.printLocation(defUnit.getLocation());
            this.writer.print("private void __jamon_innerUnit__");
            this.writer.print(defUnit.getName());
            this.writer.openList();
            this.writer.printListElement(ArgNames.WRITER_DECL);
            defUnit.printRenderArgsDecl(this.writer);
            this.writer.closeList();
            this.writer.println();
            if (defUnit.doesIO()) {
                this.writer.println("  throws " + ClassNames.IOEXCEPTION);
            }
            defUnit.generateRenderBody(this.writer, this.describer);
            this.writer.println();
        }
    }

    private void generateMethods() throws ParserErrorImpl {
        for (MethodUnit methodUnit : this.templateUnit.getDeclaredMethodUnits()) {
            this.generateMethodIntf(methodUnit);
        }
        for (MethodUnit methodUnit : this.templateUnit.getImplementedMethodUnits()) {
            this.generateMethodImpl(methodUnit);
        }
    }

    private void generateMethodIntf(MethodUnit methodUnit) {
        this.writer.println();
        for (FragmentArgument frag : methodUnit.getFragmentArgs()) {
            this.generateInnerUnitFargInterface(frag.getFragmentUnit(), false);
        }
    }

    private void generateMethodImpl(MethodUnit methodUnit) throws ParserErrorImpl {
        this.writer.println();
        this.generateJavadoc();
        this.writer.printLocation(methodUnit.getLocation());
        if (methodUnit.isOverride()) {
            this.writer.print("@Override ");
        }
        this.writer.print("protected " + (methodUnit.isAbstract() ? "abstract " : "") + "void __jamon_innerUnit__");
        this.writer.print(methodUnit.getName());
        this.writer.openList();
        this.writer.printListElement(ArgNames.WRITER_DECL);
        methodUnit.printRenderArgsDecl(this.writer);
        this.writer.closeList();
        this.writer.println();
        this.writer.println("  throws " + ClassNames.IOEXCEPTION);
        if (methodUnit.isAbstract()) {
            this.writer.println("  ;");
        } else {
            methodUnit.generateRenderBody(this.writer, this.describer);
        }
        this.writer.println();
        for (OptionalArgument arg : methodUnit.getOptionalArgsWithDefaults()) {
            if (methodUnit.isOverride()) {
                this.writer.print("@Override ");
            }
            this.writer.println("protected " + arg.getType() + " " + methodUnit.getOptionalArgDefaultMethod(arg) + "()");
            this.writer.openBlock();
            this.writer.println("return " + methodUnit.getDefaultForArg(arg) + ";");
            this.writer.closeBlock();
        }
    }

    private void generateJavadoc() {
        this.writer.println("/**");
        this.writer.println(" * @param jamonWriter");
        this.writer.println(" * @throws " + ClassNames.IOEXCEPTION);
        this.writer.println(" */");
    }

    private void generateRender() throws ParserErrorImpl {
        if (this.templateUnit.hasParentPath()) {
            this.writer.println("@Override protected void child_render_" + this.templateUnit.getInheritanceDepth() + "(" + ArgNames.WRITER_DECL + ")");
        } else {
            if (!this.templateUnit.isParent()) {
                this.writer.print("@Override ");
            }
            this.writer.println("public void renderNoFlush(" + ArgNames.WRITER_DECL + ")");
        }
        if (this.templateUnit.doesIO()) {
            this.writer.println("  throws " + ClassNames.IOEXCEPTION);
        }
        this.templateUnit.generateRenderBody(this.writer, this.describer);
        this.writer.println();
        if (this.templateUnit.isParent()) {
            this.writer.println("protected abstract void child_render_" + (this.templateUnit.getInheritanceDepth() + 1) + "(" + ArgNames.WRITER_DECL + ") throws " + ClassNames.IOEXCEPTION + ";");
            this.writer.println();
        }
    }

    private void generateEpilogue() {
        this.writer.println();
        this.writer.closeBlock();
    }

    private void generateImports() {
        this.templateUnit.printImports(this.writer);
    }

    private String getProxyClassName() {
        return PathUtils.getFullyQualifiedIntfClassName(this.getPath());
    }

    private String getImplDataClassName() {
        return this.getProxyClassName() + ".ImplData" + this.templateUnit.getGenericParams().generateGenericParamsList();
    }

    private String getParentImplClassName() {
        return PathUtils.getFullyQualifiedImplClassName(this.templateUnit.getParentPath());
    }
}

