/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jamon.codegen.AbstractArgument;
import org.jamon.codegen.FragmentArgument;
import org.jamon.codegen.OptionalArgument;
import org.jamon.codegen.RequiredArgument;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.ArgValueNode;
import org.jamon.node.ParentArgNode;
import org.jamon.node.ParentArgWithDefaultNode;

public class InheritedArgs {
    private final String parentName;
    private final ParserErrorsImpl errors;
    private final Set<AbstractArgument> visibleArgs = new HashSet<AbstractArgument>();
    private final Collection<RequiredArgument> requiredArgs;
    private final Collection<OptionalArgument> optionalArgs;
    private final Collection<FragmentArgument> fragmentArgs;
    private final Map<OptionalArgument, String> defaultOverrides = new HashMap<OptionalArgument, String>();

    public InheritedArgs(String parentName, Collection<RequiredArgument> requiredArgs, Collection<OptionalArgument> optionalArgs, Collection<FragmentArgument> fragmentArgs, ParserErrorsImpl errors) {
        this.parentName = parentName;
        this.errors = errors;
        this.requiredArgs = requiredArgs;
        this.optionalArgs = optionalArgs;
        this.fragmentArgs = fragmentArgs;
    }

    public Collection<AbstractArgument> getVisibleArgs() {
        return this.visibleArgs;
    }

    public boolean isArgVisible(AbstractArgument arg) {
        return this.visibleArgs.contains(arg);
    }

    public void addParentArg(ParentArgNode node) {
        String name = node.getName().getName();
        ArgValueNode value = node instanceof ParentArgWithDefaultNode ? ((ParentArgWithDefaultNode)node).getValue() : null;
        for (RequiredArgument requiredArgument : this.requiredArgs) {
            if (!requiredArgument.getName().equals(name)) continue;
            if (value == null) {
                this.visibleArgs.add(requiredArgument);
            } else {
                this.errors.addError(name + " is an inherited required argument, and may not be given a default value", value.getLocation());
            }
            return;
        }
        for (OptionalArgument optionalArgument : this.optionalArgs) {
            if (!optionalArgument.getName().equals(name)) continue;
            if (value != null) {
                this.defaultOverrides.put(optionalArgument, value.getValue().trim());
            }
            this.visibleArgs.add(optionalArgument);
            return;
        }
        for (FragmentArgument fragmentArgument : this.fragmentArgs) {
            if (!fragmentArgument.getName().equals(name)) continue;
            if (value == null) {
                this.visibleArgs.add(fragmentArgument);
            } else {
                this.errors.addError(name + " is an inherited fragment argument, and may not be given a default value", value.getLocation());
            }
            return;
        }
        this.errors.addError(this.parentName + " does not have an arg named " + name, node.getName().getLocation());
    }

    public String getDefaultValue(OptionalArgument arg) {
        return this.defaultOverrides.get(arg);
    }

    public Collection<OptionalArgument> getOptionalArgsWithNewDefaultValues() {
        return this.defaultOverrides.keySet();
    }
}

