/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import org.jamon.codegen.SequentialIterator;

public class SequentialList<T>
extends AbstractList<T> {
    private final List<? extends T>[] lists;
    private final int size;

    private SequentialList(List[] lists) {
        this.lists = lists;
        this.size = this.totalSize(lists);
    }

    private int totalSize(List<?>[] lists) {
        int size = 0;
        for (List<?> list : lists) {
            size += list.size();
        }
        return size;
    }

    public SequentialList(List<? extends T> list1) {
        this(new List[]{list1});
    }

    public SequentialList(List<? extends T> list1, List<? extends T> list2) {
        this(new List[]{list1, list2});
    }

    public SequentialList(List<? extends T> list1, List<? extends T> list2, List<? extends T> list3) {
        this(new List[]{list1, list2, list3});
    }

    @Override
    public T get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int listIndex = index;
        for (List<T> list : this.lists) {
            if (listIndex >= list.size()) {
                listIndex -= list.size();
                continue;
            }
            return list.get(listIndex);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<T> iterator() {
        Iterator[] iters = new Iterator[this.lists.length];
        for (int i = 0; i < this.lists.length; ++i) {
            iters[i] = this.lists[i].iterator();
        }
        return new SequentialIterator(iters);
    }
}

