/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.security.MessageDigest;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jamon.api.Location;
import org.jamon.codegen.AbstractArgument;
import org.jamon.codegen.AbstractUnit;
import org.jamon.codegen.ClassNames;
import org.jamon.codegen.CodeWriter;
import org.jamon.codegen.Concatenation;
import org.jamon.codegen.DeclaredMethodUnit;
import org.jamon.codegen.DefUnit;
import org.jamon.codegen.FragmentArgument;
import org.jamon.codegen.GenericParams;
import org.jamon.codegen.InheritedArgs;
import org.jamon.codegen.InheritedUnit;
import org.jamon.codegen.MethodUnit;
import org.jamon.codegen.OptionalArgument;
import org.jamon.codegen.OverriddenMethodUnit;
import org.jamon.codegen.PathUtils;
import org.jamon.codegen.RequiredArgument;
import org.jamon.codegen.SequentialList;
import org.jamon.codegen.TemplateDescription;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.AnnotationNode;
import org.jamon.node.ClassNode;
import org.jamon.node.GenericsParamNode;
import org.jamon.node.ImportNode;
import org.jamon.node.ParentArgNode;
import org.jamon.node.StaticImportNode;
import org.jamon.util.StringUtils;

public class TemplateUnit
extends AbstractUnit
implements InheritedUnit {
    private InheritedArgs inheritedArgs = null;
    private TemplateDescription parentDescription = TemplateDescription.EMPTY;
    private final List<RequiredArgument> declaredRequiredArgs = new LinkedList<RequiredArgument>();
    private final List<FragmentArgument> fragmentArgs = new LinkedList<FragmentArgument>();
    private final Set<OptionalArgument> declaredOptionalArgs = new HashSet<OptionalArgument>();
    private final Set<FragmentArgument> declaredFragmentArgs = new HashSet<FragmentArgument>();
    private final Map<String, DefUnit> defs = new HashMap<String, DefUnit>();
    private final Map<String, MethodUnit> methods = new HashMap<String, MethodUnit>();
    private final List<OverriddenMethodUnit> overrides = new LinkedList<OverriddenMethodUnit>();
    private final List<ImportNode> imports = new LinkedList<ImportNode>();
    private final List<StaticImportNode> staticImports = new LinkedList<StaticImportNode>();
    private final List<String> interfaces = new LinkedList<String>();
    private String parentPath;
    private boolean isParent = false;
    private String replacedTemplatePath;
    private TemplateDescription replacedTemplateDescription;
    private boolean replaceable = false;
    private final List<ClassNode> classContent = new LinkedList<ClassNode>();
    private final Set<String> dependencies = new HashSet<String>();
    private final Set<String> callNames = new HashSet<String>();
    private final Collection<String> abstractMethodNames = new HashSet<String>();
    private final GenericParams genericParams = new GenericParams();
    private String jamonContextType;
    private final List<AnnotationNode> annotations = new LinkedList<AnnotationNode>();
    private String encoding;

    public TemplateUnit(String path, ParserErrorsImpl errors) {
        super(path, null, errors, null);
    }

    public int getInheritanceDepth() {
        return this.parentDescription == null ? 0 : 1 + this.parentDescription.getInheritanceDepth();
    }

    public void setParentDescription(TemplateDescription parent) {
        this.parentDescription = parent;
        this.fragmentArgs.addAll(parent.getFragmentInterfaces());
        this.inheritedArgs = new InheritedArgs(this.getParentPath(), parent.getRequiredArgs(), parent.getOptionalArgs(), parent.getFragmentInterfaces(), this.getErrors());
        for (AbstractArgument abstractArgument : new Concatenation<FragmentArgument>((Collection<FragmentArgument>)parent.getRequiredArgs(), (Collection<FragmentArgument>)parent.getOptionalArgs(), (Collection<FragmentArgument>)parent.getFragmentInterfaces())) {
            this.addArgName(abstractArgument);
        }
        this.callNames.addAll(parent.getMethodUnits().keySet());
        this.abstractMethodNames.addAll(parent.getAbstractMethodNames());
        if (this.jamonContextType == null) {
            this.setJamonContextType(parent.getJamonContextType());
        }
    }

    @Override
    public void addParentArg(ParentArgNode arg) {
        this.inheritedArgs.addParentArg(arg);
    }

    @Override
    public List<FragmentArgument> getFragmentArgs() {
        return this.fragmentArgs;
    }

    @Override
    public void addFragmentArg(FragmentArgument arg) {
        this.fragmentArgs.add(arg);
        this.declaredFragmentArgs.add(arg);
    }

    public Collection<FragmentArgument> getDeclaredFragmentArgs() {
        return this.declaredFragmentArgs;
    }

    @Override
    public void addRequiredArg(RequiredArgument arg) {
        this.declaredRequiredArgs.add(arg);
    }

    @Override
    public void addOptionalArg(OptionalArgument arg) {
        this.declaredOptionalArgs.add(arg);
    }

    @Override
    public List<RequiredArgument> getSignatureRequiredArgs() {
        return new SequentialList<RequiredArgument>(this.parentDescription.getRequiredArgs(), this.declaredRequiredArgs);
    }

    @Override
    public Collection<OptionalArgument> getSignatureOptionalArgs() {
        return new Concatenation<OptionalArgument>((Collection<OptionalArgument>)this.parentDescription.getOptionalArgs(), (Collection<OptionalArgument>)this.declaredOptionalArgs);
    }

    public String getOptionalArgDefault(OptionalArgument arg) {
        return this.declaredOptionalArgs.contains(arg) ? arg.getDefault() : this.inheritedArgs.getDefaultValue(arg);
    }

    @Override
    public Collection<AbstractArgument> getVisibleArgs() {
        return this.inheritedArgs == null ? new Concatenation<AbstractArgument>((Collection<AbstractArgument>)this.getDeclaredRenderArgs(), (Collection<AbstractArgument>)this.getDeclaredOptionalArgs()) : new Concatenation<OptionalArgument>((Collection<OptionalArgument>)this.inheritedArgs.getVisibleArgs(), (Collection<OptionalArgument>)this.getDeclaredRenderArgs(), this.getDeclaredOptionalArgs());
    }

    public Collection<OptionalArgument> getDeclaredOptionalArgs() {
        return this.declaredOptionalArgs;
    }

    public Collection<String> getTemplateDependencies() {
        return this.dependencies;
    }

    private void checkCallName(String name, Location location) {
        if (!this.callNames.add(name)) {
            this.getErrors().addError("multiple defs and/or methods named " + name, location);
        }
    }

    public void makeDefUnit(String defName, Location location) {
        this.checkCallName(defName, location);
        this.defs.put(defName, new DefUnit(defName, this, this.getErrors(), location));
    }

    public Collection<DefUnit> getDefUnits() {
        return this.defs.values();
    }

    public DefUnit getDefUnit(String name) {
        return this.defs.get(name);
    }

    public void makeMethodUnit(String methodName, Location location, boolean isAbstract) {
        this.checkCallName(methodName, location);
        this.methods.put(methodName, new DeclaredMethodUnit(methodName, this, this.getErrors(), location, isAbstract));
        if (isAbstract) {
            this.abstractMethodNames.add(methodName);
        }
    }

    public OverriddenMethodUnit makeOverridenMethodUnit(String name, Location location) {
        DeclaredMethodUnit methodUnit = (DeclaredMethodUnit)this.parentDescription.getMethodUnits().get(name);
        if (methodUnit == null) {
            this.getErrors().addError("There is no such method " + name + " to override", location);
            methodUnit = new DeclaredMethodUnit(name, this, this.getErrors(), location);
        }
        this.abstractMethodNames.remove(name);
        OverriddenMethodUnit override = new OverriddenMethodUnit(methodUnit, this, this.getErrors(), location);
        this.overrides.add(override);
        return override;
    }

    public MethodUnit getMethodUnit(String name) {
        return this.methods.containsKey(name) ? this.methods.get(name) : this.parentDescription.getMethodUnits().get(name);
    }

    public Collection<MethodUnit> getSignatureMethodUnits() {
        return new Concatenation<MethodUnit>(this.getDeclaredMethodUnits(), this.parentDescription.getMethodUnits().values());
    }

    public Collection<MethodUnit> getDeclaredMethodUnits() {
        return this.methods.values();
    }

    public Collection<MethodUnit> getImplementedMethodUnits() {
        return new Concatenation<MethodUnit>(this.getDeclaredMethodUnits(), (Collection<MethodUnit>)this.overrides);
    }

    public Collection<String> getAbstractMethodNames() {
        return this.abstractMethodNames;
    }

    private Iterable<ImportNode> getImports() {
        return this.imports;
    }

    public void addStaticImport(StaticImportNode node) {
        this.staticImports.add(node);
    }

    private Iterable<StaticImportNode> getStaticImports() {
        return this.staticImports;
    }

    public void addImport(ImportNode node) {
        this.imports.add(node);
    }

    public void addInterface(String interfase) {
        this.interfaces.add(interfase);
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
        this.dependencies.add(parentPath);
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public boolean hasParentPath() {
        return this.parentPath != null;
    }

    public void setReplacedTemplatePathAndDescription(String replacedTemplatePath, TemplateDescription templateDescription) {
        this.replacedTemplatePath = replacedTemplatePath;
        this.replacedTemplateDescription = templateDescription;
        this.dependencies.add(replacedTemplatePath);
    }

    public String getReplacedTemplatePath() {
        return this.replacedTemplatePath;
    }

    public TemplateDescription getReplacedTemplateDescription() {
        return this.replacedTemplateDescription;
    }

    public boolean isReplacing() {
        return this.replacedTemplatePath != null;
    }

    public void setReplaceable(boolean replaceable) {
        this.replaceable = replaceable;
    }

    public boolean isReplaceable() {
        return this.replaceable;
    }

    public String getProxyParentClass() {
        return this.hasParentPath() ? PathUtils.getFullyQualifiedIntfClassName(this.getParentPath()) : ClassNames.TEMPLATE;
    }

    public boolean isParent() {
        return this.isParent;
    }

    public void setIsParent() {
        this.isParent = true;
    }

    public void printClassContent(CodeWriter writer) {
        for (ClassNode node : this.classContent) {
            writer.printLocation(node.getLocation());
            writer.println(node.getContent());
        }
    }

    public void addClassContent(ClassNode node) {
        this.classContent.add(node);
    }

    public void addCallPath(String callPath) {
        this.dependencies.add(callPath);
    }

    public Collection<RequiredArgument> getParentRenderArgs() {
        return new Concatenation<RequiredArgument>((Collection<RequiredArgument>)this.parentDescription.getRequiredArgs(), (Collection<RequiredArgument>)this.parentDescription.getFragmentInterfaces());
    }

    public void printImports(CodeWriter writer) {
        for (ImportNode importNode : this.getImports()) {
            writer.printLocation(importNode.getLocation());
            writer.println("import " + importNode.getName() + ";");
        }
        for (StaticImportNode staticImportNode : this.getStaticImports()) {
            writer.printLocation(staticImportNode.getLocation());
            writer.println("import static " + staticImportNode.getName() + ";");
        }
        writer.println();
    }

    public void printParentRenderArgs(CodeWriter writer) {
        TemplateUnit.printArgs(writer, this.getParentRenderArgs());
    }

    public void printParentRenderArgsDecl(CodeWriter writer) {
        TemplateUnit.printArgsDecl(writer, this.getParentRenderArgs());
    }

    public Collection<? extends RequiredArgument> getDeclaredRenderArgs() {
        return new Concatenation<FragmentArgument>((Collection<FragmentArgument>)this.declaredRequiredArgs, (Collection<FragmentArgument>)this.declaredFragmentArgs);
    }

    public Collection<AbstractArgument> getDeclaredArgs() {
        return new Concatenation<AbstractArgument>((Collection<AbstractArgument>)this.getDeclaredRenderArgs(), (Collection<AbstractArgument>)this.declaredOptionalArgs);
    }

    public void printDeclaredRenderArgs(CodeWriter writer) {
        TemplateUnit.printArgs(writer, this.getDeclaredRenderArgs());
    }

    public void printDeclaredRenderArgsDecl(CodeWriter writer) {
        TemplateUnit.printArgsDecl(writer, this.getDeclaredRenderArgs());
    }

    public void printInterfaces(CodeWriter writer) {
        if (this.interfaces.size() > 0) {
            writer.print("  implements ");
            writer.openList("", false);
            for (String intrface : this.interfaces) {
                writer.printListElement(intrface);
            }
            writer.closeList("");
        }
    }

    @Override
    protected void generateInterfaceSummary(StringBuilder buf) {
        super.generateInterfaceSummary(buf);
        buf.append("GenericParams:");
        buf.append(this.getGenericParams().generateGenericsDeclaration());
        buf.append("\n");
        buf.append("replaceable:").append(this.isReplaceable()).append("\n");
        if (this.parentDescription != null) {
            buf.append("Parent sig: ").append(this.parentDescription.getSignature()).append("\n");
        }
        for (FragmentArgument arg : this.getFragmentArgs()) {
            buf.append("Fragment: ").append(arg.getName()).append("\n");
            arg.getFragmentUnit().generateInterfaceSummary(buf);
        }
    }

    public String getSignature() {
        try {
            StringBuilder buf = new StringBuilder();
            this.generateInterfaceSummary(buf);
            return StringUtils.byteArrayToHexString(MessageDigest.getInstance("MD5").digest(buf.toString().getBytes("UTF-8")));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to generate signature", e);
        }
    }

    public GenericParams getGenericParams() {
        return this.genericParams;
    }

    public void setJamonContextType(String jamonContextType) {
        this.jamonContextType = jamonContextType;
    }

    public String getJamonContextType() {
        return this.jamonContextType;
    }

    public boolean isOriginatingJamonContext() {
        return this.jamonContextType != null && (!this.hasParentPath() || this.parentDescription.getJamonContextType() == null);
    }

    public void addGenericsParamNode(GenericsParamNode node) {
        this.genericParams.addParam(node);
    }

    public void addAnnotationNode(AnnotationNode node) {
        this.annotations.add(node);
    }

    public Iterable<AnnotationNode> getAnnotations() {
        return this.annotations;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

