/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.node;

import java.util.ArrayList;
import java.util.List;
import org.jamon.api.Location;
import org.jamon.node.AbstractNode;
import org.jamon.node.Analysis;
import org.jamon.node.GenericsBoundNode;

public class GenericsParamNode
extends AbstractNode {
    private final String m_name;
    private final List<GenericsBoundNode> m_bounds = new ArrayList<GenericsBoundNode>();

    public GenericsParamNode(Location p_location, String p_name) {
        super(p_location);
        this.m_name = p_name;
        if (this.m_name == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public void apply(Analysis p_analysis) {
        p_analysis.caseGenericsParamNode(this);
    }

    public String getName() {
        return this.m_name;
    }

    public GenericsParamNode addBound(GenericsBoundNode p_bound) {
        if (p_bound == null) {
            throw new NullPointerException();
        }
        this.m_bounds.add(p_bound);
        return this;
    }

    public List<GenericsBoundNode> getBounds() {
        return this.m_bounds;
    }

    @Override
    public boolean equals(Object p_obj) {
        return p_obj != null && super.equals(p_obj) && this.m_name.equals(((GenericsParamNode)p_obj).m_name) && ((Object)this.m_bounds).equals(((GenericsParamNode)p_obj).m_bounds);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.m_name.hashCode() ^ ((Object)this.m_bounds).hashCode();
    }

    @Override
    protected void propertiesToString(StringBuilder p_buffer) {
        super.propertiesToString(p_buffer);
        GenericsParamNode.addProperty(p_buffer, "name", this.m_name);
        GenericsParamNode.addPropertyList(p_buffer, "bound", this.m_bounds);
    }
}

