/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.jamon.api.Location;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.AbstractBodyNode;
import org.jamon.node.AbstractNode;
import org.jamon.node.DefaultEscapeNode;
import org.jamon.node.DocNode;
import org.jamon.node.EmitNode;
import org.jamon.node.EscapeNode;
import org.jamon.node.ForNode;
import org.jamon.node.IfNode;
import org.jamon.node.JavaNode;
import org.jamon.node.LiteralNode;
import org.jamon.node.TextNode;
import org.jamon.node.WhileNode;
import org.jamon.parser.AbstractParser;
import org.jamon.parser.AbstractTagEndDetector;
import org.jamon.parser.ArgsParser;
import org.jamon.parser.CallParser;
import org.jamon.parser.ForParser;
import org.jamon.parser.FragmentArgsParser;
import org.jamon.parser.HashEndDetector;
import org.jamon.parser.IfParser;
import org.jamon.parser.PositionalPushbackReader;
import org.jamon.parser.TagEndDetector;
import org.jamon.parser.WhileParser;

public abstract class AbstractBodyParser<Node extends AbstractBodyNode>
extends AbstractParser {
    public static final String ENCOUNTERED_ELSE_TAG_WITHOUT_PRIOR_IF_TAG = "encountered <%else> tag without prior <%if ...%> tag";
    public static final String ENCOUNTERED_ELSEIF_TAG_WITHOUT_PRIOR_IF_TAG = "encountered <%elseif ...%> tag without prior <%if ...%> tag";
    public static final String ESCAPE_TAG_IN_SUBCOMPONENT = "<%escape> tags only allowed at the top level of a document";
    public static final String GENERIC_TAG_IN_SUBCOMPONENT = "<%generic> tags only allowed at the top level of a document";
    public static final String ANNOTATE_TAG_IN_SUBCOMPONENT = "<%annotate> tags only allowed at the top level of a document";
    public static final String CLASS_TAG_IN_SUBCOMPONENT = "<%class> sections only allowed at the top level of a document";
    public static final String UNEXPECTED_NAMED_FRAGMENT_CLOSE_ERROR = "</|> tags can only be used to close named call fragments";
    public static final String UNEXPECTED_FRAGMENTS_CLOSE_ERROR = "</&> tags can only be used to close call fragments";
    public static final String EMIT_ESCAPE_CODE_ERROR = "Emit escaping code must be a letter";
    public static final String EMIT_MISSING_TAG_END_ERROR = "Did not see expected '%>' to end a <% ... %> tag";
    public static final String PERCENT_GREATER_THAN_EOF_ERROR = "Reached end of file while looking for '%>'";
    public static final String EXTENDS_TAG_IN_SUBCOMPONENT = "<%extends ...> tag only allowed at the top level of a document";
    private static final String ALIASES_TAG_IN_SUBCOMPONENT = "<%aliases> sections only allowed at the top level of a document";
    public static final String IMPLEMENTS_TAG_IN_SUBCOMPONENT = "<%implements> sections only allowed at the top level of a document";
    public static final String REPLACES_TAG_IN_SUBCOMPONENT = "<%replaces ...> tag only allowed at the top level of a document";
    public static final String REPLACEABLE_TAG_IN_SUBCOMPONENT = "<%replaceable ...> tag only allowed at the top level of a document";
    private static final String IMPORT_TAG_IN_SUBCOMPONENT = "<%import> sections only allowed at the top level of a document";
    public static final String PARENT_ARGS_TAG_IN_SUBCOMPONENT = "<%xargs> sections only allowed at the top level of a document";
    public static final String PARENT_MARKER_TAG_IN_SUBCOMPONENT = "<%abstract> tag only allowed at the top level of a document";
    protected StringBuilder text = new StringBuilder();
    protected final Node root;
    protected final Location bodyStart;
    private boolean doneParsing;

    protected AbstractBodyParser(Node rootNode, PositionalPushbackReader reader, ParserErrorsImpl errors) {
        super(reader, errors);
        this.root = rootNode;
        this.bodyStart = reader.getNextLocation();
    }

    protected void handleText() {
        if (this.text.length() > 0) {
            ((AbstractBodyNode)this.root).addSubNode(new TextNode(this.reader.getCurrentNodeLocation(), this.text.toString()));
            this.text = new StringBuilder();
        }
        this.reader.markNodeBeginning();
    }

    public AbstractBodyParser<Node> parse() throws IOException {
        int c;
        this.doneParsing = false;
        this.reader.markNodeEnd();
        boolean isTopLevel = this.isTopLevel();
        block10: while ((isTopLevel || !this.doneParsing) && (c = this.reader.read()) >= 0) {
            int c1;
            if (c == 60) {
                Location tagLocation = this.reader.getLocation();
                c1 = this.reader.read();
                switch (c1) {
                    case 37: {
                        this.handleText();
                        if (this.soakWhitespace()) {
                            this.handleEmit(tagLocation);
                        } else {
                            this.handleTag(this.readTagName(), tagLocation);
                        }
                        this.reader.markNodeEnd();
                        break;
                    }
                    case 38: {
                        this.handleText();
                        ((AbstractBodyNode)this.root).addSubNode(new CallParser(this.reader, this.errors, tagLocation).getCallNode());
                        this.reader.markNodeEnd();
                        break;
                    }
                    case 47: {
                        c = this.reader.read();
                        switch (c) {
                            case 37: {
                                String tagName = this.readTagName();
                                this.doneParsing();
                                if (!this.checkForTagClosure(tagLocation)) continue block10;
                                this.handleTagClose(tagName, tagLocation);
                                break;
                            }
                            case 38: {
                                if (this.readChar('>')) {
                                    if (!this.handleFragmentsClose(tagLocation)) continue block10;
                                    this.doneParsing();
                                    break;
                                }
                                this.text.append("</&");
                                break;
                            }
                            case 124: {
                                if (this.readChar('>')) {
                                    if (!this.handleNamedFragmentClose(tagLocation)) continue block10;
                                    this.doneParsing();
                                    break;
                                }
                                this.text.append("</|");
                                break;
                            }
                            default: {
                                this.reader.unread(c);
                                this.text.append("</");
                                break;
                            }
                        }
                        continue block10;
                    }
                    default: {
                        if (c1 >= 0) {
                            this.reader.unread(c1);
                        }
                        this.text.append((char)c);
                    }
                }
                continue;
            }
            if (c == 37 && this.reader.isLineStart()) {
                this.handleText();
                ((AbstractBodyNode)this.root).addSubNode(new JavaNode(this.reader.getCurrentNodeLocation(), this.readLine()));
                this.reader.markNodeEnd();
                continue;
            }
            if (c == 92) {
                ArrayList<Integer> toPushBack = new ArrayList<Integer>();
                c1 = this.reader.read();
                toPushBack.add(c1);
                if (c1 == 13) {
                    c1 = this.reader.read();
                    toPushBack.add(0, c1);
                }
                if (c1 == 10) continue;
                this.text.append((char)c);
                Iterator i$ = toPushBack.iterator();
                while (i$.hasNext()) {
                    int c2 = (Integer)i$.next();
                    this.reader.unread(c2);
                }
                continue;
            }
            this.text.append((char)c);
        }
        this.handleText();
        if (!this.doneParsing && !isTopLevel) {
            this.handleEof();
        }
        return this;
    }

    protected void doneParsing() {
        this.doneParsing = true;
    }

    private void handleEmit(Location tagLocation) throws IOException {
        try {
            HashEndDetector endDetector = new HashEndDetector();
            String emitExpr = this.readJava(tagLocation, endDetector);
            if (!endDetector.endedWithHash()) {
                ((AbstractBodyNode)this.root).addSubNode(new EmitNode(tagLocation, emitExpr, new DefaultEscapeNode(this.reader.getLocation())));
            } else {
                Location escapingLocation = this.reader.getLocation();
                int c = this.reader.read();
                if (this.isLetter((char)c)) {
                    this.soakWhitespace();
                    if (this.readChar('%') && this.readChar('>')) {
                        ((AbstractBodyNode)this.root).addSubNode(new EmitNode(tagLocation, emitExpr, new EscapeNode(escapingLocation, Character.toString((char)c))));
                    } else {
                        this.addError(this.reader.getLocation(), EMIT_MISSING_TAG_END_ERROR);
                    }
                } else {
                    this.addError(this.reader.getLocation(), EMIT_ESCAPE_CODE_ERROR);
                }
            }
        }
        catch (ParserErrorImpl e) {
            this.addError(e);
        }
    }

    private boolean isLetter(char character) {
        return 'A' <= character && character <= 'Z' || 'a' <= character && character <= 'z';
    }

    protected boolean isTopLevel() {
        return false;
    }

    protected void handleTag(String tagName, Location tagLocation) throws IOException {
        if ("java".equals(tagName)) {
            this.handleJavaTag(tagLocation);
        } else if ("LITERAL".equals(tagName)) {
            this.handleLiteralTag(tagLocation);
        } else if ("def".equals(tagName)) {
            this.handleDefTag(tagLocation);
        } else if ("method".equals(tagName)) {
            this.handleMethodTag(tagLocation);
        } else if ("override".equals(tagName)) {
            this.handleOverrideTag(tagLocation);
        } else if ("while".equals(tagName)) {
            this.handleWhileTag(tagLocation);
        } else if ("for".equals(tagName)) {
            this.handleForTag(tagLocation);
        } else if ("if".equals(tagName)) {
            this.handleIfTag(tagLocation);
        } else if ("else".equals(tagName)) {
            this.handleElseTag(tagLocation);
        } else if ("elseif".equals(tagName)) {
            this.handleElseIfTag(tagLocation);
        } else if ("args".equals(tagName)) {
            try {
                ((AbstractBodyNode)this.root).addSubNode(new ArgsParser(this.reader, this.errors, tagLocation).getArgsNode());
            }
            catch (ParserErrorImpl e) {
                this.addError(e);
            }
        } else if ("frag".equals(tagName)) {
            try {
                ((AbstractBodyNode)this.root).addSubNode(new FragmentArgsParser(this.reader, this.errors, tagLocation).getFragmentArgsNode());
            }
            catch (ParserErrorImpl e) {
                this.addError(e);
            }
        } else if ("xargs".equals(tagName)) {
            this.handleParentArgsNode(tagLocation);
        } else if ("class".equals(tagName)) {
            this.handleClassTag(tagLocation);
        } else if ("extends".equals(tagName)) {
            this.handleExtendsTag(tagLocation);
        } else if ("alias".equals(tagName)) {
            this.handleAliasesTag(tagLocation);
        } else if ("absmeth".equals(tagName)) {
            this.handleAbsMethodTag(tagLocation);
        } else if ("implements".equals(tagName)) {
            this.handleImplementsTag(tagLocation);
        } else if ("replaces".equals(tagName)) {
            this.handleReplacesTag(tagLocation);
        } else if ("replaceable".equals(tagName)) {
            this.handleReplaceableTag(tagLocation);
        } else if ("import".equals(tagName)) {
            this.handleImportTag(tagLocation);
        } else if ("doc".equals(tagName)) {
            this.handleDocTag(tagLocation);
        } else if ("abstract".equals(tagName)) {
            this.handleParentMarkerTag(tagLocation);
        } else if ("escape".equals(tagName)) {
            this.handleEscapeTag(tagLocation);
        } else if ("generic".equals(tagName)) {
            this.handleGenericTag(tagLocation);
        } else if ("annotate".equals(tagName)) {
            this.handleAnnotationTag(tagLocation);
        } else if (this.checkForTagClosure(tagLocation)) {
            this.addError(tagLocation, "Unknown tag <%" + tagName + ">");
        }
    }

    protected void handleTagClose(String tagName, Location tagLocation) throws IOException {
        this.addError(tagLocation, "Unexpected tag close </%" + tagName + ">");
    }

    protected abstract void handleEof();

    protected boolean handleNamedFragmentClose(Location tagLocation) throws IOException {
        this.addError(tagLocation, UNEXPECTED_NAMED_FRAGMENT_CLOSE_ERROR);
        return false;
    }

    protected boolean handleFragmentsClose(Location tagLocation) throws IOException {
        this.addError(tagLocation, UNEXPECTED_FRAGMENTS_CLOSE_ERROR);
        return false;
    }

    protected void handleMethodTag(Location tagLocation) throws IOException {
        this.addError(tagLocation, "<%method> sections only allowed at the top level of a document");
    }

    protected void handleOverrideTag(Location tagLocation) throws IOException {
        this.addError(tagLocation, "<%override> sections only allowed at the top level of a document");
    }

    protected void handleDefTag(Location tagLocation) throws IOException {
        this.addError(tagLocation, "<%def> sections only allowed at the top level of a document");
    }

    protected void handleAbsMethodTag(Location tagLocation) throws IOException {
        this.addError(tagLocation, "<%absmeth> sections only allowed at the top level of a document");
    }

    protected void handleWhileTag(Location tagLocation) throws IOException {
        try {
            ((AbstractBodyNode)this.root).addSubNode((AbstractNode)new WhileParser(new WhileNode(tagLocation, this.readCondition(tagLocation, "while")), this.reader, this.errors).parse().getRootNode());
        }
        catch (ParserErrorImpl e) {
            this.addError(e);
        }
    }

    protected void handleForTag(Location tagLocation) throws IOException {
        try {
            ((AbstractBodyNode)this.root).addSubNode((AbstractNode)new ForParser(new ForNode(tagLocation, this.readCondition(tagLocation, "for")), this.reader, this.errors).parse().getRootNode());
        }
        catch (ParserErrorImpl e) {
            this.addError(e);
        }
    }

    protected void handleIfTag(Location tagLocation) throws IOException {
        try {
            IfParser parser;
            parser.parse();
            for (parser = new IfParser(new IfNode(tagLocation, this.readCondition(tagLocation, "if")), this.reader, this.errors); parser != null; parser = parser.getContinuation()) {
                ((AbstractBodyNode)this.root).addSubNode((AbstractNode)parser.getRootNode());
            }
        }
        catch (ParserErrorImpl e) {
            this.addError(e);
        }
    }

    protected String readCondition(Location tagLocation, String tagName) throws IOException, ParserErrorImpl {
        if (!this.soakWhitespace()) {
            throw new ParserErrorImpl(tagLocation, "Malformed <%" + tagName + " ...%> tag");
        }
        return this.readJava(tagLocation, new ConditionEndDetector("<%" + tagName + " ...%>"));
    }

    protected void handleElseTag(Location tagLocation) throws IOException {
        this.addError(tagLocation, ENCOUNTERED_ELSE_TAG_WITHOUT_PRIOR_IF_TAG);
    }

    protected void handleElseIfTag(Location tagLocation) throws IOException {
        this.addError(tagLocation, ENCOUNTERED_ELSEIF_TAG_WITHOUT_PRIOR_IF_TAG);
    }

    protected void handleParentArgsNode(Location tagLocation) throws IOException {
        this.addError(tagLocation, PARENT_ARGS_TAG_IN_SUBCOMPONENT);
    }

    protected void handleParentMarkerTag(Location tagLocation) throws IOException {
        this.addError(tagLocation, PARENT_MARKER_TAG_IN_SUBCOMPONENT);
    }

    protected void handleEscapeTag(Location tagLocation) throws IOException {
        this.addError(tagLocation, ESCAPE_TAG_IN_SUBCOMPONENT);
    }

    protected void handleGenericTag(Location tagLocation) throws IOException {
        this.addError(tagLocation, GENERIC_TAG_IN_SUBCOMPONENT);
    }

    protected void handleAnnotationTag(Location tagLocation) throws IOException {
        this.addError(tagLocation, ANNOTATE_TAG_IN_SUBCOMPONENT);
    }

    private void handleJavaTag(Location tagLocation) throws IOException {
        if (this.readChar('>')) {
            this.handleJavaCode(tagLocation, new JavaTagEndDetector());
        } else {
            this.soakWhitespace();
            this.handleJavaCode(tagLocation, new JavaSnippetTagEndDetector());
        }
    }

    private void handleJavaCode(Location tagLocation, TagEndDetector endTagDetector) throws IOException {
        try {
            ((AbstractBodyNode)this.root).addSubNode(new JavaNode(tagLocation, this.readJava(tagLocation, endTagDetector)));
            this.soakWhitespace();
        }
        catch (ParserErrorImpl e) {
            this.addError(e);
        }
    }

    protected void handleLiteralTag(Location tagLocation) throws IOException {
        if (this.checkForTagClosure(tagLocation)) {
            ((AbstractBodyNode)this.root).addSubNode(new LiteralNode(tagLocation, this.readUntil("</%LITERAL>", tagLocation)));
        }
    }

    protected void handleClassTag(Location tagLocation) throws IOException {
        this.addError(tagLocation, CLASS_TAG_IN_SUBCOMPONENT);
    }

    protected void handleExtendsTag(Location tagLocation) throws IOException {
        this.addError(tagLocation, EXTENDS_TAG_IN_SUBCOMPONENT);
    }

    protected void handleImplementsTag(Location tagLocation) throws IOException {
        this.addError(tagLocation, IMPLEMENTS_TAG_IN_SUBCOMPONENT);
    }

    protected void handleReplacesTag(Location tagLocation) throws IOException {
        this.addError(tagLocation, REPLACES_TAG_IN_SUBCOMPONENT);
    }

    protected void handleReplaceableTag(Location tagLocation) throws IOException {
        this.addError(tagLocation, REPLACEABLE_TAG_IN_SUBCOMPONENT);
    }

    protected void handleImportTag(Location tagLocation) throws IOException {
        this.addError(tagLocation, IMPORT_TAG_IN_SUBCOMPONENT);
    }

    protected void handleAliasesTag(Location tagLocation) throws IOException {
        this.addError(tagLocation, ALIASES_TAG_IN_SUBCOMPONENT);
    }

    private void handleDocTag(Location tagLocation) throws IOException {
        if (this.checkForTagClosure(tagLocation)) {
            ((AbstractBodyNode)this.root).addSubNode(new DocNode(tagLocation, this.readUntil("</%doc>", tagLocation)));
        }
        this.soakWhitespace();
    }

    protected String readTagName() throws IOException {
        int c;
        StringBuilder buffer = new StringBuilder();
        while ((c = this.reader.read()) >= 0 && !Character.isWhitespace((char)c) && c != 62) {
            buffer.append((char)c);
        }
        if (c >= 0) {
            this.reader.unread(c);
        }
        return buffer.toString();
    }

    protected String readLine() throws IOException {
        int c;
        StringBuilder line = new StringBuilder();
        while ((c = this.reader.read()) >= 0) {
            line.append((char)c);
            if (c != 10) continue;
            break;
        }
        return line.toString();
    }

    public Node getRootNode() {
        return this.root;
    }

    protected static class JavaSnippetTagEndDetector
    extends AbstractTagEndDetector {
        protected JavaSnippetTagEndDetector() {
            super("%>");
        }
    }

    private static class JavaTagEndDetector
    extends AbstractTagEndDetector {
        public JavaTagEndDetector() {
            super("</%java>");
        }
    }

    private static class ConditionEndDetector
    implements TagEndDetector {
        private boolean seenPercent = false;
        private final String tagName;

        public ConditionEndDetector(String tagName) {
            this.tagName = tagName;
        }

        @Override
        public int checkEnd(char character) {
            switch (character) {
                case '%': {
                    this.seenPercent = true;
                    return 0;
                }
                case '>': {
                    if (this.seenPercent) {
                        return 2;
                    }
                    this.seenPercent = false;
                    return 0;
                }
            }
            this.seenPercent = false;
            return 0;
        }

        @Override
        public ParserErrorImpl getEofError(Location startLocation) {
            return new ParserErrorImpl(startLocation, "Reached end of file while reading " + this.tagName + " tag");
        }

        @Override
        public void resetEndMatch() {
        }
    }
}

