/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import java.io.IOException;
import org.jamon.api.Location;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.AbstractPathNode;
import org.jamon.parser.ClassNameParser;
import org.jamon.parser.PathParser;
import org.jamon.parser.PositionalPushbackReader;
import org.jamon.parser.TagEndDetector;
import org.jamon.parser.TypeNameParser;

public class AbstractParser {
    public static final String MALFORMED_TAG_ERROR = "Malformed tag";
    public static final String EOF_IN_JAVA_QUOTE_ERROR = "Reached end of file while inside a java quote";
    public static final String NOT_AN_IDENTIFIER_ERROR = "identifier exepected";
    public static final String BAD_JAVA_TYPE_SPECIFIER = "Bad java type specifier";
    public static final String BAD_ARGS_CLOSE_TAG = "malformed </%args> tag";
    public static final String INCOMPLETE_ARRAY_SPECIFIER_ERROR = "Expecting ']'";
    protected final PositionalPushbackReader reader;
    protected final ParserErrorsImpl errors;

    public AbstractParser(PositionalPushbackReader reader, ParserErrorsImpl errors) {
        this.reader = reader;
        this.errors = errors;
    }

    protected boolean soakWhitespace() throws IOException {
        int c;
        boolean whitespaceSeen = false;
        while ((c = this.reader.read()) >= 0 && Character.isWhitespace((char)c)) {
            whitespaceSeen = true;
        }
        this.reader.unread(c);
        return whitespaceSeen;
    }

    protected void addError(Location location, String message) {
        this.errors.addError(new ParserErrorImpl(location, message));
    }

    protected void addError(ParserErrorImpl error) {
        this.errors.addError(error);
    }

    protected String readIdentifierOrThrow() throws IOException, NotAnIdentifierException {
        StringBuilder builder = new StringBuilder();
        int c = this.reader.read();
        if (c <= 0 || !Character.isJavaIdentifierStart((char)c)) {
            this.reader.unread(c);
            throw new NotAnIdentifierException();
        }
        builder.append((char)c);
        while ((c = this.reader.read()) >= 0 && Character.isJavaIdentifierPart((char)c)) {
            builder.append((char)c);
        }
        this.reader.unread(c);
        return builder.toString();
    }

    protected String readIdentifier(boolean addErrorIfNoneFound) throws IOException {
        try {
            return this.readIdentifierOrThrow();
        }
        catch (NotAnIdentifierException e) {
            if (addErrorIfNoneFound) {
                this.addError(this.reader.getNextLocation(), NOT_AN_IDENTIFIER_ERROR);
            }
            return "";
        }
    }

    protected boolean readChar(char chararacter) throws IOException {
        int c = this.reader.read();
        if (c == chararacter) {
            return true;
        }
        this.reader.unread(c);
        return false;
    }

    protected String readUntil(String end, Location startLocation) throws IOException {
        int n;
        StringBuilder buffer = new StringBuilder();
        int charsSeen = 0;
        int n2 = -1;
        while (charsSeen < end.length() && (n = this.reader.read()) >= 0) {
            if (end.charAt(charsSeen) == n) {
                ++charsSeen;
                continue;
            }
            if (charsSeen > 0) {
                buffer.append(end.substring(0, charsSeen));
                charsSeen = 0;
                this.reader.unread(n);
                continue;
            }
            buffer.append((char)n);
        }
        if (n < 0) {
            this.addError(startLocation, AbstractParser.eofErrorMessage(end));
        }
        return buffer.toString();
    }

    public static String eofErrorMessage(String end) {
        return "Reached end of file while looking for '" + end + "'";
    }

    protected String readJava(Location startLocation, TagEndDetector tagEndDetector) throws IOException, ParserErrorImpl {
        StringBuilder buffer = new StringBuilder();
        int c = -1;
        boolean inString = false;
        boolean inChar = false;
        Location quoteStart = null;
        while ((c = this.reader.read()) >= 0) {
            int endTokenLength;
            switch (c) {
                case 34: {
                    boolean bl = inString = !inChar && !inString;
                    if (inString) {
                        quoteStart = this.reader.getLocation();
                        tagEndDetector.resetEndMatch();
                        break;
                    }
                    quoteStart = null;
                    break;
                }
                case 39: {
                    boolean bl = inChar = !inString && !inChar;
                    if (inChar) {
                        quoteStart = this.reader.getLocation();
                        tagEndDetector.resetEndMatch();
                        break;
                    }
                    quoteStart = null;
                    break;
                }
                case 92: {
                    if (!inString && !inChar) break;
                    buffer.append((char)c);
                    c = this.reader.read();
                    if (c >= 0) break;
                    this.reader.unread(c);
                }
            }
            buffer.append((char)c);
            if (inString || inChar || (endTokenLength = tagEndDetector.checkEnd((char)c)) <= 0) continue;
            buffer.delete(buffer.length() - endTokenLength, buffer.length());
            return buffer.toString();
        }
        if (quoteStart != null) {
            throw new ParserErrorImpl(quoteStart, EOF_IN_JAVA_QUOTE_ERROR);
        }
        throw tagEndDetector.getEofError(startLocation);
    }

    protected boolean checkForTagClosure(Location tagLocation) throws IOException {
        if (this.readChar('>')) {
            return true;
        }
        this.addError(tagLocation, MALFORMED_TAG_ERROR);
        return false;
    }

    protected boolean checkToken(String token) throws IOException {
        for (int i = 0; i < token.length(); ++i) {
            if (this.readChar(token.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected String readType(Location location) throws IOException {
        try {
            return new TypeNameParser(location, this.reader, this.errors).getType();
        }
        catch (ParserErrorImpl e) {
            this.addError(e);
            return "";
        }
    }

    protected String readClassName(Location p_location) throws IOException {
        try {
            return new ClassNameParser(p_location, this.reader, this.errors).getType();
        }
        catch (ParserErrorImpl e) {
            this.addError(e);
            return "";
        }
    }

    protected AbstractPathNode parsePath() throws IOException {
        return new PathParser(this.reader, this.errors).getPathNode();
    }

    protected boolean readAndAppendChar(char p_char, StringBuilder builder) throws IOException {
        if (this.readChar(p_char)) {
            builder.append(p_char);
            return true;
        }
        return false;
    }

    protected static class NotAnIdentifierException
    extends Exception {
        private static final long serialVersionUID = 2006091701L;

        protected NotAnIdentifierException() {
        }
    }
}

