/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import org.jamon.api.Location;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.parser.TagEndDetector;

class AbstractTagEndDetector
implements TagEndDetector {
    private final String endTag;
    private final int endTagLength;
    int charsSeen = 0;

    protected AbstractTagEndDetector(String endTag) {
        this.endTag = endTag;
        this.endTagLength = endTag.length();
    }

    @Override
    public int checkEnd(char character) {
        if (character == this.endTag.charAt(this.charsSeen)) {
            if (++this.charsSeen == this.endTagLength) {
                return this.charsSeen;
            }
        } else {
            this.charsSeen = 0;
        }
        return 0;
    }

    @Override
    public ParserErrorImpl getEofError(Location startLocation) {
        return new ParserErrorImpl(startLocation, "Reached end of file while looking for '" + this.endTag + "'");
    }

    @Override
    public void resetEndMatch() {
        this.charsSeen = 0;
    }
}

