/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import java.io.IOException;
import org.jamon.api.Location;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.ArgNameNode;
import org.jamon.node.ArgValueNode;
import org.jamon.node.ParentArgNode;
import org.jamon.node.ParentArgWithDefaultNode;
import org.jamon.node.ParentArgsNode;
import org.jamon.parser.AbstractParser;
import org.jamon.parser.OptionalValueTagEndDetector;
import org.jamon.parser.PositionalPushbackReader;

public final class ParentArgsParser
extends AbstractParser {
    private final ParentArgsNode parentArgsNode;
    public static final String MALFORMED_PARENT_ARGS_CLOSE = "Expecting parent arg declaration or '</%xargs>'";

    public ParentArgsParser(PositionalPushbackReader reader, ParserErrorsImpl errors, Location tagLocation) throws IOException {
        super(reader, errors);
        this.parentArgsNode = new ParentArgsNode(tagLocation);
        if (this.checkForTagClosure(tagLocation)) {
            while (true) {
                this.soakWhitespace();
                if (this.readChar('<')) {
                    Location location = reader.getLocation();
                    if (!this.checkToken("/%xargs>")) {
                        this.addError(location, MALFORMED_PARENT_ARGS_CLOSE);
                    }
                    this.soakWhitespace();
                    return;
                }
                try {
                    this.handleParentArg(this.parentArgsNode);
                }
                catch (ParserErrorImpl e) {
                    this.addError(e);
                    return;
                }
            }
        }
    }

    public ParentArgsNode getParentArgsNode() {
        return this.parentArgsNode;
    }

    private void handleParentArg(ParentArgsNode parentArgsNode) throws IOException, ParserErrorImpl {
        ArgNameNode argName = new ArgNameNode(this.reader.getNextLocation(), this.readIdentifier(true));
        this.soakWhitespace();
        if (this.readChar(';')) {
            parentArgsNode.addArg(new ParentArgNode(argName.getLocation(), argName));
        } else if (this.readChar('=')) {
            this.readChar('>');
            this.soakWhitespace();
            Location valueLocation = this.reader.getNextLocation();
            parentArgsNode.addArg(new ParentArgWithDefaultNode(argName.getLocation(), argName, new ArgValueNode(valueLocation, this.readJava(valueLocation, new OptionalValueTagEndDetector()))));
        } else {
            throw new ParserErrorImpl(this.reader.getNextLocation(), "Expecting a ';', '=' or '=>'");
        }
    }
}

