/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import java.io.IOException;
import org.jamon.api.Location;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.AbsolutePathNode;
import org.jamon.node.AbstractPathNode;
import org.jamon.node.NamedAliasPathNode;
import org.jamon.node.PathElementNode;
import org.jamon.node.RelativePathNode;
import org.jamon.node.RootAliasPathNode;
import org.jamon.node.UpdirNode;
import org.jamon.parser.AbstractParser;
import org.jamon.parser.PositionalPushbackReader;

public class PathParser
extends AbstractParser {
    public static final String GENERIC_PATH_ERROR = "Malformed path";
    private final AbstractPathNode path = this.parse();

    public PathParser(PositionalPushbackReader reader, ParserErrorsImpl errors) throws IOException {
        super(reader, errors);
    }

    public AbstractPathNode getPathNode() {
        return this.path;
    }

    private AbstractPathNode parse() throws IOException {
        AbstractPathNode path;
        Location location = this.reader.getNextLocation();
        int c = this.reader.read();
        switch (c) {
            case 47: {
                path = this.readChar('/') ? new RootAliasPathNode(location) : new AbsolutePathNode(location);
                this.addToPath(path, false);
                break;
            }
            case 46: {
                this.reader.unread(c);
                path = new RelativePathNode(location);
                this.addToPath(path, true);
                break;
            }
            default: {
                if (Character.isJavaIdentifierStart((char)c)) {
                    this.reader.unread(c);
                    String identifier = this.readIdentifier(true);
                    c = this.reader.read();
                    if (c == 47) {
                        c = this.reader.read();
                        if (c == 47) {
                            path = new NamedAliasPathNode(location, identifier);
                            this.addToPath(path, false);
                            break;
                        }
                        this.reader.unread(c);
                        path = new RelativePathNode(location).addPathElement(new PathElementNode(location, identifier));
                        this.addToPath(path, false);
                        break;
                    }
                    this.reader.unread(c);
                    path = new RelativePathNode(location).addPathElement(new PathElementNode(location, identifier));
                    break;
                }
                this.addError(location, GENERIC_PATH_ERROR);
                path = new RelativePathNode(location);
            }
        }
        return path;
    }

    private void addToPath(AbstractPathNode path, boolean updirsAllowedAtStart) throws IOException {
        int c;
        StringBuilder identifier = new StringBuilder();
        boolean identStart = true;
        boolean updirsAllowed = updirsAllowedAtStart;
        Location location = this.reader.getNextLocation();
        while ((c = this.reader.read()) >= 0) {
            if (c == 47) {
                if (identStart) {
                    this.addError(location, GENERIC_PATH_ERROR);
                    return;
                }
                path.addPathElement(new PathElementNode(location, identifier.toString()));
                identifier = new StringBuilder();
                identStart = true;
                updirsAllowed = false;
                location = this.reader.getNextLocation();
                continue;
            }
            if (c == 46) {
                if (updirsAllowed) {
                    if (this.reader.read() == 46) {
                        path.addPathElement(new UpdirNode(location));
                        identifier = new StringBuilder();
                        identStart = true;
                        c = this.reader.read();
                        if (c == 47) {
                            location = this.reader.getNextLocation();
                            continue;
                        }
                        if (!Character.isJavaIdentifierPart((char)c)) continue;
                        this.addError(location, GENERIC_PATH_ERROR);
                        return;
                    }
                    this.addError(location, GENERIC_PATH_ERROR);
                    return;
                }
                this.addError(location, GENERIC_PATH_ERROR);
                return;
            }
            if (identStart ? Character.isJavaIdentifierStart((char)c) : Character.isJavaIdentifierPart((char)c)) {
                identStart = false;
                identifier.append((char)c);
                continue;
            }
            this.reader.unread(c);
            break;
        }
        if (!identStart) {
            path.addPathElement(new PathElementNode(location, identifier.toString()));
        } else {
            this.addError(this.reader.getCurrentNodeLocation(), GENERIC_PATH_ERROR);
        }
    }
}

