/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

public class AnnotationReflector {
    private Map<String, Annotation> annotations = new HashMap<String, Annotation>();

    public AnnotationReflector(Class<?> clazz) {
        for (Annotation annotation : clazz.getAnnotations()) {
            this.annotations.put(annotation.annotationType().getName(), annotation);
        }
    }

    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        Annotation annotation = this.annotations.get(clazz.getName());
        return (T)((Annotation)clazz.cast(this.proxyAnnotation(clazz, annotation)));
    }

    private Object proxyAnnotation(Class<?> clazz, final Object annotation) {
        return clazz.cast(Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result = annotation.getClass().getMethod(method.getName(), new Class[0]).invoke(annotation, new Object[0]);
                return AnnotationReflector.this.maybeProxyAnnotation(method.getReturnType(), result);
            }
        }));
    }

    private Object maybeProxyAnnotation(Class<?> type, Object object) {
        if (object == null) {
            return null;
        }
        if (type.isAnnotation()) {
            return this.proxyAnnotation(type, object);
        }
        if (type.isArray() && type.getComponentType().isAnnotation()) {
            int arrayLength = Array.getLength(object);
            Object array = Array.newInstance(type.getComponentType(), arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                Array.set(array, i, this.proxyAnnotation(type.getComponentType(), Array.get(object, i)));
            }
            return array;
        }
        return object;
    }
}

