/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jamon.util.JavaCompiler;

public class ExternalJavaCompiler
implements JavaCompiler {
    private final List<String> compilerCommand;

    public ExternalJavaCompiler(String javac, List<String> compilerArgs) {
        this.compilerCommand = new ArrayList<String>(compilerArgs.size() + 1);
        this.compilerCommand.add(javac);
        this.compilerCommand.addAll(compilerArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String compile(String[] javaFiles) {
        Process p;
        String[] cmdline = new String[javaFiles.length + this.compilerCommand.size()];
        this.compilerCommand.toArray(cmdline);
        System.arraycopy(javaFiles, 0, cmdline, this.compilerCommand.size(), javaFiles.length);
        try {
            p = Runtime.getRuntime().exec(cmdline);
        }
        catch (IOException e) {
            return e.getMessage();
        }
        StreamConsumer stderr = new StreamConsumer(p.getErrorStream());
        try {
            Thread errThread = new Thread(stderr);
            errThread.start();
            int code = -1;
            try {
                code = p.waitFor();
            }
            catch (InterruptedException e) {
                errThread.interrupt();
            }
            try {
                errThread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            String string = code == 0 ? null : stderr.getContents();
            return string;
        }
        finally {
            try {
                stderr.close();
            }
            catch (IOException e) {
                return e.getMessage();
            }
        }
    }

    private static class StreamConsumer
    implements Runnable {
        private final InputStream stream;
        private final StringBuilder buffer = new StringBuilder();

        StreamConsumer(InputStream stream) {
            this.stream = stream;
        }

        private void close() throws IOException {
            this.stream.close();
        }

        synchronized String getContents() {
            return this.buffer.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] buf = new byte[1024];
            boolean eof = false;
            while (!eof) {
                try {
                    int read = this.stream.read(buf);
                    if (read == -1) {
                        eof = true;
                        continue;
                    }
                    if (read == 0) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            eof = true;
                        }
                        continue;
                    }
                    StringBuilder stringBuilder = this.buffer;
                    synchronized (stringBuilder) {
                        this.buffer.append(new String(buf, 0, read));
                    }
                }
                catch (IOException e) {
                    eof = true;
                }
            }
        }
    }
}

