/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.jamon.util.StringUtils;

public class WorkDirClassLoader
extends ClassLoader {
    private final String workDir;
    private Loader loader;

    public WorkDirClassLoader(ClassLoader parent, String workDir) {
        super(parent);
        this.workDir = workDir;
    }

    private File getFileForClass(String name) {
        return new File(this.workDir, StringUtils.classNameToFilePath(name) + ".class");
    }

    public synchronized void invalidate() {
        this.loader = null;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (!this.getFileForClass(name).exists()) {
            return super.loadClass(name, resolve);
        }
        if (this.loader == null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    WorkDirClassLoader.this.loader = new Loader();
                    return null;
                }
            });
        }
        return this.loader.loadClass(name, resolve);
    }

    public String toString() {
        return super.toString() + " { workDir: " + this.workDir + "; parent: " + this.getParent() + " }";
    }

    private class Loader
    extends ClassLoader {
        private final Map<String, Class<?>> cache;

        Loader() {
            super(WorkDirClassLoader.this);
            this.cache = new HashMap();
        }

        public String toString() {
            return super.toString() + " { " + " parent: " + this.getParent() + " }";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] readBytesForClass(String name) throws IOException {
            FileInputStream s = new FileInputStream(WorkDirClassLoader.this.getFileForClass(name));
            try {
                int i;
                byte[] buf = new byte[1024];
                byte[] bytes = new byte[]{};
                while ((i = s.read(buf)) > 0) {
                    byte[] newbytes = new byte[bytes.length + i];
                    System.arraycopy(bytes, 0, newbytes, 0, bytes.length);
                    System.arraycopy(buf, 0, newbytes, bytes.length, i);
                    bytes = newbytes;
                }
                byte[] byArray = bytes;
                return byArray;
            }
            finally {
                s.close();
            }
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (!WorkDirClassLoader.this.getFileForClass(name).exists()) {
                return super.loadClass(name, resolve);
            }
            Class<?> c = this.cache.get(name);
            if (c == null) {
                try {
                    byte[] code = this.readBytesForClass(name);
                    c = this.defineClass(name, code, 0, code.length);
                    if (resolve) {
                        this.resolveClass(c);
                    }
                    this.cache.put(name, c);
                }
                catch (IOException e) {
                    throw new ClassNotFoundException(e.getMessage());
                }
            }
            return c;
        }
    }
}

