/*
 * Decompiled with CFR 0.152.
 */
package org.jamon;

import org.jamon.AbstractTemplateManager;
import org.jamon.AbstractTemplateProxy;
import org.jamon.IdentityTemplateReplacer;
import org.jamon.TemplateManager;
import org.jamon.TemplateReplacer;

public class BasicTemplateManager
extends AbstractTemplateManager {
    private final ClassLoader m_classLoader;

    public BasicTemplateManager() {
        this((ClassLoader)null);
    }

    public BasicTemplateManager(ClassLoader p_classLoader) {
        this(p_classLoader, IdentityTemplateReplacer.INSTANCE);
    }

    public BasicTemplateManager(ClassLoader p_classLoader, TemplateReplacer p_templateReplacer) {
        super(p_templateReplacer);
        this.m_classLoader = p_classLoader == null ? this.getClass().getClassLoader() : p_classLoader;
    }

    @Override
    protected AbstractTemplateProxy.Intf constructImplFromReplacedProxy(AbstractTemplateProxy p_replacedProxy) {
        return p_replacedProxy.constructImpl();
    }

    @Override
    public AbstractTemplateProxy constructProxy(String p_path) {
        try {
            return this.getProxyClass(p_path).getConstructor(TemplateManager.class).newInstance(this);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("The template at path " + p_path + " could not be found");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Class<? extends AbstractTemplateProxy> getProxyClass(String p_path) throws ClassNotFoundException {
        String path = p_path;
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        return this.m_classLoader.loadClass(path.replace('/', '.')).asSubclass(AbstractTemplateProxy.class);
    }
}

