/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.maven.notice;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.jasig.maven:maven-notice-plugin:1.1.0", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven NOTICE Generation Plugin", 0);
        this.append(sb, "Generates Apache style NOTICE files", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "check".equals(this.goal)) {
            this.append(sb, "notice:check", 0);
            this.append(sb, "Checks the NOTICE file to make sure it matches the expected output", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedModules", 2);
                this.append(sb, "ArtifactIds of child modules to exclude", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeOptional", 2);
                this.append(sb, "Whether to exclude optional dependencies and any transitive dependencies of those.\nFor example, if your POM declares an optional dependency A with a transitive dependency B:\n-\tA will be excluded as it is directly defined as an optional dependency.\n-\tB will be excluded as it is resolved via A, which is optional.\n-\tHowever, if B were to be explicitly declared as a non-optional dependency in your pom, then it would be included.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeScopes", 2);
                this.append(sb, "List of scopes, like 'compile', 'test', etc. If specified, dependencies with these scopes will be omitted from the NOTICE file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileName (Default: NOTICE)", 2);
                this.append(sb, "Output file name", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateChildNotices (Default: true)", 2);
                this.append(sb, "Set if a NOTICE file should be generated for each child module", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeChildDependencies (Default: true)", 2);
                this.append(sb, "Set if the NOTICE file should include all dependencies from all child modules.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeScopes", 2);
                this.append(sb, "List of scopes, like 'compile', 'test', etc. If specified, only dependencies with these scopes will be listed in the NOTICE file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "licenseLookup", 2);
                this.append(sb, "Deprecated. use licenseMapping", 3);
                this.append(sb, "", 0);
                this.append(sb, "Use licenseMapping", 3);
                this.append(sb, "", 0);
                this.append(sb, "licenseMapping", 2);
                this.append(sb, "License Mapping XML files / URLs. Lookups are done in-order with files being checked top to bottom for matches", 3);
                this.append(sb, "", 0);
                this.append(sb, "noticeMessage (Default:   {0} under {1})", 2);
                this.append(sb, "The MessageFormat syntax string used to generate each license line in the NOTICE file\n{0} - artifact name\n{1} - license name\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "noticeTemplate (Default: NOTICE.template)", 2);
                this.append(sb, "Template for NOTICE file generation", 3);
                this.append(sb, "", 0);
                this.append(sb, "noticeTemplatePlaceholder (Default: #GENERATED_NOTICES#)", 2);
                this.append(sb, "Placeholder string in the NOTICE template file", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDir (Default: ${basedir})", 2);
                this.append(sb, "Output location for the generated NOTICE file", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipChecks", 2);
                this.append(sb, "Parameter to skip running checks entirely.", 3);
                this.append(sb, "Expression: ${skip.checks}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "generate".equals(this.goal)) {
            this.append(sb, "notice:generate", 0);
            this.append(sb, "Generates the NOTICE file", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedModules", 2);
                this.append(sb, "ArtifactIds of child modules to exclude", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeOptional", 2);
                this.append(sb, "Whether to exclude optional dependencies and any transitive dependencies of those.\nFor example, if your POM declares an optional dependency A with a transitive dependency B:\n-\tA will be excluded as it is directly defined as an optional dependency.\n-\tB will be excluded as it is resolved via A, which is optional.\n-\tHowever, if B were to be explicitly declared as a non-optional dependency in your pom, then it would be included.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeScopes", 2);
                this.append(sb, "List of scopes, like 'compile', 'test', etc. If specified, dependencies with these scopes will be omitted from the NOTICE file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileName (Default: NOTICE)", 2);
                this.append(sb, "Output file name", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateChildNotices (Default: true)", 2);
                this.append(sb, "Set if a NOTICE file should be generated for each child module", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeChildDependencies (Default: true)", 2);
                this.append(sb, "Set if the NOTICE file should include all dependencies from all child modules.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeScopes", 2);
                this.append(sb, "List of scopes, like 'compile', 'test', etc. If specified, only dependencies with these scopes will be listed in the NOTICE file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "licenseLookup", 2);
                this.append(sb, "Deprecated. use licenseMapping", 3);
                this.append(sb, "", 0);
                this.append(sb, "Use licenseMapping", 3);
                this.append(sb, "", 0);
                this.append(sb, "licenseMapping", 2);
                this.append(sb, "License Mapping XML files / URLs. Lookups are done in-order with files being checked top to bottom for matches", 3);
                this.append(sb, "", 0);
                this.append(sb, "noticeMessage (Default:   {0} under {1})", 2);
                this.append(sb, "The MessageFormat syntax string used to generate each license line in the NOTICE file\n{0} - artifact name\n{1} - license name\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "noticeTemplate (Default: NOTICE.template)", 2);
                this.append(sb, "Template for NOTICE file generation", 3);
                this.append(sb, "", 0);
                this.append(sb, "noticeTemplatePlaceholder (Default: #GENERATED_NOTICES#)", 2);
                this.append(sb, "Placeholder string in the NOTICE template file", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDir (Default: ${basedir})", 2);
                this.append(sb, "Output location for the generated NOTICE file", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipChecks", 2);
                this.append(sb, "Parameter to skip running checks entirely.", 3);
                this.append(sb, "Expression: ${skip.checks}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "notice:help", 0);
            this.append(sb, "Display help information on maven-notice-plugin.\nCall\n\u00a0\u00a0mvn\u00a0notice:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

