/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.entity.entitycache;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ejb.NoSuchEntityException;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentInstance;
import org.jboss.as.ejb3.component.entity.entitycache.ReadyEntityCache;

public class ReferenceCountingEntityCache
implements ReadyEntityCache {
    private final ConcurrentMap<Object, CacheEntry> cache = new ConcurrentHashMap<Object, CacheEntry>();
    private final EntityBeanComponent component;

    public ReferenceCountingEntityCache(EntityBeanComponent component) {
        this.component = component;
    }

    @Override
    public synchronized void create(EntityBeanComponentInstance instance) {
        CacheEntry entry = this.realCreate(instance);
        entry.referenceCount.incrementAndGet();
    }

    private CacheEntry realCreate(EntityBeanComponentInstance instance) {
        CacheEntry cacheEntry = new CacheEntry(instance);
        CacheEntry existing = this.cache.putIfAbsent(instance.getPrimaryKey(), cacheEntry);
        if (existing != null) {
            if (existing.instance.isRemoved()) {
                existing.replacedInstance = instance;
            } else {
                throw EjbMessages.MESSAGES.instanceAlreadyRegisteredForPK(instance.getPrimaryKey());
            }
        }
        return cacheEntry;
    }

    @Override
    public synchronized boolean contains(Object key) {
        if (this.cache.containsKey(key)) {
            CacheEntry cacheEntry = (CacheEntry)this.cache.get(key);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean containsNotRemoved(Object key) {
        if (this.cache.containsKey(key)) {
            CacheEntry cacheEntry = (CacheEntry)this.cache.get(key);
            if (cacheEntry.replacedInstance != null) {
                return !cacheEntry.replacedInstance.isRemoved();
            }
            return !cacheEntry.instance.isRemoved();
        }
        return false;
    }

    @Override
    public synchronized EntityBeanComponentInstance get(Object key) throws NoSuchEntityException {
        if (!this.cache.containsKey(key)) {
            EntityBeanComponentInstance instance = this.createInstance(key);
            this.realCreate(instance);
        }
        CacheEntry cacheEntry = (CacheEntry)this.cache.get(key);
        cacheEntry.referenceCount.incrementAndGet();
        if (cacheEntry.replacedInstance != null) {
            return cacheEntry.replacedInstance;
        }
        return cacheEntry.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void release(EntityBeanComponentInstance instance, boolean success) {
        if (instance.isDiscarded()) {
            return;
        }
        if (instance.getPrimaryKey() == null) {
            return;
        }
        CacheEntry cacheEntry = (CacheEntry)this.cache.get(instance.getPrimaryKey());
        if (cacheEntry == null) {
            throw EjbMessages.MESSAGES.entityBeanInstanceNotFoundInCache(instance);
        }
        if (cacheEntry.replacedInstance != null && instance == cacheEntry.replacedInstance) {
            if (success) {
                cacheEntry.instance = cacheEntry.replacedInstance;
            } else if (cacheEntry.instance.isDiscarded()) {
                this.cache.remove(instance.getPrimaryKey());
                return;
            }
            cacheEntry.replacedInstance = null;
        }
        if (!success && instance.isRemoved()) {
            instance.setRemoved(false);
        }
        if (cacheEntry.referenceCount.decrementAndGet() == 0) {
            Object pk = instance.getPrimaryKey();
            try {
                instance.passivate();
                this.component.releaseEntityBeanInstance(instance);
            }
            finally {
                this.cache.remove(pk);
            }
        }
    }

    @Override
    public synchronized void discard(EntityBeanComponentInstance instance) {
        if (instance.getPrimaryKey() == null) {
            return;
        }
        CacheEntry entry = (CacheEntry)this.cache.get(instance.getPrimaryKey());
        if (entry != null) {
            if (instance == entry.replacedInstance) {
                entry.replacedInstance = null;
            } else if (entry.replacedInstance == null) {
                this.cache.remove(instance.getPrimaryKey());
            }
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    private EntityBeanComponentInstance createInstance(Object pk) {
        EntityBeanComponentInstance instance = this.component.acquireUnAssociatedInstance();
        instance.associate(pk);
        return instance;
    }

    private class CacheEntry {
        private final AtomicInteger referenceCount = new AtomicInteger(0);
        private volatile EntityBeanComponentInstance instance;
        private volatile EntityBeanComponentInstance replacedInstance;

        private CacheEntry(EntityBeanComponentInstance instance) {
            this.instance = instance;
        }
    }
}

