/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.task;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.jboss.as.ejb3.timerservice.CalendarTimer;
import org.jboss.as.ejb3.timerservice.TimerState;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.as.ejb3.timerservice.task.TimerTask;

public class CalendarTimerTask
extends TimerTask<CalendarTimer> {
    public CalendarTimerTask(CalendarTimer calendarTimer) {
        super(calendarTimer);
    }

    @Override
    protected void callTimeout() throws Exception {
        CalendarTimer calendarTimer = (CalendarTimer)this.getTimer();
        if (calendarTimer.getNextExpiration() != null && !calendarTimer.isInRetry()) {
            calendarTimer.scheduleTimeout(false);
        }
        if (calendarTimer.isAutoTimer()) {
            TimedObjectInvoker invoker = this.timerService.getInvoker();
            invoker.callTimeout(calendarTimer, calendarTimer.getTimeoutMethod());
        } else {
            this.timerService.getInvoker().callTimeout(calendarTimer);
        }
    }

    @Override
    protected Date calculateNextTimeout() {
        Date currentTimeout = ((CalendarTimer)this.getTimer()).getNextExpiration();
        if (currentTimeout == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(currentTimeout);
        Calendar nextTimeout = ((CalendarTimer)this.getTimer()).getCalendarTimeout().getNextTimeout(cal);
        if (nextTimeout != null) {
            return nextTimeout.getTime();
        }
        return null;
    }

    @Override
    protected void scheduleTimeoutIfRequired() {
        if (((CalendarTimer)this.timer).getNextExpiration() != null) {
            ((CalendarTimer)this.timer).scheduleTimeout(false);
        }
    }

    @Override
    protected void postTimeoutProcessing() {
        CalendarTimer calendarTimer = (CalendarTimer)this.getTimer();
        TimerState timerState = calendarTimer.getState();
        if (timerState != TimerState.CANCELED && timerState != TimerState.EXPIRED) {
            if (calendarTimer.getNextExpiration() == null) {
                calendarTimer.expireTimer();
            } else {
                calendarTimer.setTimerState(TimerState.ACTIVE);
                this.timerService.persistTimer(calendarTimer, false);
            }
        }
    }
}

