/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors.encoding;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.interception.ClientInterceptor;
import org.jboss.resteasy.annotations.interception.EncoderPrecedence;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.spi.interception.MessageBodyWriterContext;
import org.jboss.resteasy.spi.interception.MessageBodyWriterInterceptor;

@Provider
@ServerInterceptor
@ClientInterceptor
@EncoderPrecedence
public class GZIPEncodingInterceptor
implements MessageBodyWriterInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(MessageBodyWriterContext context) throws IOException, WebApplicationException {
        Object encoding = context.getHeaders().getFirst((Object)"Content-Encoding");
        if (encoding != null && encoding.toString().equalsIgnoreCase("gzip")) {
            OutputStream old = context.getOutputStream();
            EndableGZIPOutputStream gzipOutputStream = new EndableGZIPOutputStream(old);
            context.setOutputStream(gzipOutputStream);
            try {
                context.proceed();
            }
            finally {
                ((GZIPOutputStream)gzipOutputStream).finish();
                context.setOutputStream(old);
            }
            return;
        }
        context.proceed();
    }

    private static class EndableGZIPOutputStream
    extends GZIPOutputStream {
        public EndableGZIPOutputStream(OutputStream os) throws IOException {
            super(os);
        }

        @Override
        public void finish() throws IOException {
            super.finish();
            this.def.end();
        }
    }
}

