/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.specimpl.HttpHeadersImpl;
import org.jboss.resteasy.specimpl.PathSegmentImpl;
import org.jboss.resteasy.specimpl.UriBuilderImpl;
import org.jboss.resteasy.specimpl.UriInfoImpl;
import org.jboss.resteasy.util.MediaTypeHelper;
import org.jboss.resteasy.util.PathHelper;

public class ServletUtil {
    public static UriInfoImpl extractUriInfo(HttpServletRequest request, String servletPrefix) {
        String contextPath = request.getContextPath();
        if (servletPrefix != null && servletPrefix.length() > 0) {
            if (!contextPath.endsWith("/") && !servletPrefix.startsWith("/")) {
                contextPath = contextPath + "/";
            }
            contextPath = contextPath + servletPrefix;
        }
        URI absolutePath = null;
        try {
            URL absolute = new URL(request.getRequestURL().toString());
            UriBuilderImpl builder = new UriBuilderImpl();
            builder.scheme(absolute.getProtocol());
            builder.host(absolute.getHost());
            builder.port(absolute.getPort());
            builder.path(absolute.getPath());
            builder.replaceQuery(absolute.getQuery());
            absolutePath = builder.build(new Object[0]);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        String path = PathHelper.getEncodedPathInfo(absolutePath.getRawPath(), contextPath);
        List<PathSegment> pathSegments = PathSegmentImpl.parseSegments(path, false);
        URI baseURI = absolutePath;
        if (!path.trim().equals("")) {
            String tmpContextPath = contextPath;
            if (!tmpContextPath.endsWith("/")) {
                tmpContextPath = tmpContextPath + "/";
            }
            baseURI = UriBuilder.fromUri((URI)absolutePath).replacePath(tmpContextPath).build(new Object[0]);
        }
        UriInfoImpl uriInfo = new UriInfoImpl(absolutePath, baseURI, path, request.getQueryString(), pathSegments);
        return uriInfo;
    }

    public static HttpHeaders extractHttpHeaders(HttpServletRequest request) {
        HttpHeadersImpl headers = new HttpHeadersImpl();
        MultivaluedMap<String, String> requestHeaders = ServletUtil.extractRequestHeaders(request);
        headers.setRequestHeaders(requestHeaders);
        List<MediaType> acceptableMediaTypes = ServletUtil.extractAccepts(requestHeaders);
        List<String> acceptableLanguages = ServletUtil.extractLanguages(requestHeaders);
        headers.setAcceptableMediaTypes(acceptableMediaTypes);
        headers.setAcceptableLanguages(acceptableLanguages);
        headers.setLanguage((String)requestHeaders.getFirst((Object)"Content-Language"));
        String contentType = request.getContentType();
        if (contentType != null) {
            headers.setMediaType(MediaType.valueOf((String)contentType));
        }
        Map<String, Cookie> cookies = ServletUtil.extractCookies(request);
        headers.setCookies(cookies);
        return headers;
    }

    static Map<String, Cookie> extractCookies(HttpServletRequest request) {
        HashMap<String, Cookie> cookies = new HashMap<String, Cookie>();
        if (request.getCookies() != null) {
            for (javax.servlet.http.Cookie cookie : request.getCookies()) {
                cookies.put(cookie.getName(), new Cookie(cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getVersion()));
            }
        }
        return cookies;
    }

    public static List<MediaType> extractAccepts(MultivaluedMap<String, String> requestHeaders) {
        ArrayList<MediaType> acceptableMediaTypes = new ArrayList<MediaType>();
        List accepts = (List)requestHeaders.get((Object)"Accept");
        if (accepts == null) {
            return acceptableMediaTypes;
        }
        for (String accept : accepts) {
            acceptableMediaTypes.addAll(MediaTypeHelper.parseHeader(accept));
        }
        return acceptableMediaTypes;
    }

    public static List<String> extractLanguages(MultivaluedMap<String, String> requestHeaders) {
        ArrayList<String> acceptable = new ArrayList<String>();
        List accepts = (List)requestHeaders.get((Object)"Accept-Language");
        if (accepts == null) {
            return acceptable;
        }
        for (String accept : accepts) {
            String[] splits;
            for (String split : splits = accept.split(",")) {
                acceptable.add(split.trim());
            }
        }
        return acceptable;
    }

    public static MultivaluedMap<String, String> extractRequestHeaders(HttpServletRequest request) {
        Headers<String> requestHeaders = new Headers<String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = (String)headerValues.nextElement();
                requestHeaders.add(headerName, headerValue);
            }
        }
        return requestHeaders;
    }
}

