/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.generic;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import java.util.Optional;
import org.jdbi.v3.core.generic.internal.TypeParameter;
import org.jdbi.v3.core.generic.internal.TypeToken;

public class GenericTypes {
    private static final TypeVariable<Class<Map>> KEY;
    private static final TypeVariable<Class<Map>> VALUE;

    private GenericTypes() {
        throw new UnsupportedOperationException("utility class");
    }

    public static Class<?> getErasedType(Type type) {
        return TypeToken.of(type).getRawType();
    }

    public static Optional<Type> findGenericParameter(Type type, Class<?> parameterizedSupertype) {
        Type parameterType = GenericTypes.resolveType(parameterizedSupertype.getTypeParameters()[0], type);
        return parameterType instanceof Class || parameterType instanceof ParameterizedType ? Optional.of(parameterType) : Optional.empty();
    }

    public static Type resolveType(Type type, Type contextType) {
        return TypeToken.of(contextType).resolveType(type).getType();
    }

    public static boolean isArray(Type type) {
        return type instanceof Class && ((Class)type).isArray();
    }

    public static Type resolveMapEntryType(Type mapType) {
        Type keyType = GenericTypes.resolveType(KEY, mapType);
        Type valueType = GenericTypes.resolveType(VALUE, mapType);
        return GenericTypes.resolveMapEntryType(keyType, valueType);
    }

    public static Type resolveMapEntryType(Type keyType, Type valueType) {
        return GenericTypes.resolveMapEntryType(TypeToken.of(keyType), TypeToken.of(valueType));
    }

    private static <K, V> Type resolveMapEntryType(TypeToken<K> keyType, TypeToken<V> valueType) {
        return new TypeToken<Map.Entry<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType).getType();
    }

    static {
        TypeVariable<Class<T>>[] mapParams = Map.class.getTypeParameters();
        KEY = mapParams[0];
        VALUE = mapParams[1];
    }
}

