/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.reflect;

import java.beans.ConstructorProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jdbi.v3.core.mapper.Nested;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.RowMapperFactory;
import org.jdbi.v3.core.mapper.SingleColumnMapper;
import org.jdbi.v3.core.mapper.reflect.ColumnName;
import org.jdbi.v3.core.mapper.reflect.ColumnNameMatcher;
import org.jdbi.v3.core.mapper.reflect.JdbiConstructors;
import org.jdbi.v3.core.mapper.reflect.ReflectionMapperUtil;
import org.jdbi.v3.core.mapper.reflect.ReflectionMappers;
import org.jdbi.v3.core.statement.StatementContext;

public class ConstructorMapper<T>
implements RowMapper<T> {
    static final String DEFAULT_PREFIX = "";
    private final Constructor<T> constructor;
    private final String prefix;
    private final ConstructorProperties constructorProperties;
    private final Map<Parameter, ConstructorMapper<?>> nestedMappers = new ConcurrentHashMap();

    public static RowMapperFactory factory(Class<?> clazz) {
        return RowMapperFactory.of(clazz, ConstructorMapper.of(clazz));
    }

    public static RowMapperFactory factory(Class<?> clazz, String prefix) {
        return RowMapperFactory.of(clazz, ConstructorMapper.of(clazz, prefix));
    }

    public static RowMapperFactory factory(Constructor<?> constructor) {
        return RowMapperFactory.of(constructor.getDeclaringClass(), ConstructorMapper.of(constructor));
    }

    public static RowMapperFactory factory(Constructor<?> constructor, String prefix) {
        return RowMapperFactory.of(constructor.getDeclaringClass(), ConstructorMapper.of(constructor, prefix));
    }

    public static <T> RowMapper<T> of(Class<T> type) {
        return ConstructorMapper.of(JdbiConstructors.findConstructorFor(type));
    }

    public static <T> RowMapper<T> of(Class<T> type, String prefix) {
        return ConstructorMapper.of(JdbiConstructors.findConstructorFor(type), prefix);
    }

    public static <T> RowMapper<T> of(Constructor<T> constructor) {
        return ConstructorMapper.of(constructor, DEFAULT_PREFIX);
    }

    public static <T> RowMapper<T> of(Constructor<T> constructor, String prefix) {
        return new ConstructorMapper<T>(constructor, prefix);
    }

    private ConstructorMapper(Constructor<T> constructor, String prefix) {
        this.constructor = constructor;
        this.prefix = prefix.toLowerCase();
        this.constructorProperties = constructor.getAnnotation(ConstructorProperties.class);
    }

    @Override
    public T map(ResultSet rs, StatementContext ctx) throws SQLException {
        return this.specialize(rs, ctx).map(rs, ctx);
    }

    @Override
    public RowMapper<T> specialize(ResultSet rs, StatementContext ctx) throws SQLException {
        List<String> columnNames = ReflectionMapperUtil.getColumnNames(rs);
        List<ColumnNameMatcher> columnNameMatchers = ctx.getConfig(ReflectionMappers.class).getColumnNameMatchers();
        ArrayList<String> unmatchedColumns = new ArrayList<String>(columnNames);
        RowMapper<T> mapper = this.specialize0(rs, ctx, columnNames, columnNameMatchers, unmatchedColumns);
        if (ctx.getConfig(ReflectionMappers.class).isStrictMatching() && unmatchedColumns.stream().anyMatch(col -> col.startsWith(this.prefix))) {
            throw new IllegalArgumentException(String.format("Mapping constructor-injected type %s could not match parameters for columns: %s", this.constructor.getDeclaringClass().getSimpleName(), unmatchedColumns));
        }
        return mapper;
    }

    private RowMapper<T> specialize0(ResultSet rs, StatementContext ctx, List<String> columnNames, List<ColumnNameMatcher> columnNameMatchers, List<String> unmatchedColumns) throws SQLException {
        int count = this.constructor.getParameterCount();
        Parameter[] parameters = this.constructor.getParameters();
        RowMapper[] mappers = new RowMapper[count];
        for (int i = 0; i < count; ++i) {
            Parameter parameter = parameters[i];
            Nested anno = parameter.getAnnotation(Nested.class);
            if (anno == null) {
                String paramName = this.prefix + ConstructorMapper.paramName(parameters, i, this.constructorProperties);
                int columnIndex = ReflectionMapperUtil.findColumnIndex(paramName, columnNames, columnNameMatchers, () -> this.debugName(parameter)).orElseThrow(() -> new IllegalArgumentException(String.format("Constructor '%s' parameter '%s' has no column in the result set. Verify that the Java compiler is configured to emit parameter names, that your result set has the columns expected, or annotate the parameter names explicitly with @ColumnName", this.constructor, paramName)));
                Type type = parameter.getParameterizedType();
                mappers[i] = ctx.findColumnMapperFor(type).map(mapper -> new SingleColumnMapper(mapper, columnIndex + 1)).orElseThrow(() -> new IllegalArgumentException(String.format("Could not find column mapper for type '%s' of parameter '%s' for constructor '%s'", type, paramName, this.constructor)));
                unmatchedColumns.remove(columnNames.get(columnIndex));
                continue;
            }
            String nestedPrefix = this.prefix + anno.value();
            mappers[i] = this.nestedMappers.computeIfAbsent(parameter, p -> new ConstructorMapper(JdbiConstructors.findConstructorFor(p.getType()), nestedPrefix)).specialize0(rs, ctx, columnNames, columnNameMatchers, unmatchedColumns);
        }
        return (r, c) -> {
            Object[] params = new Object[count];
            for (int i = 0; i < count; ++i) {
                params[i] = mappers[i].map(r, c);
            }
            return this.construct(params);
        };
    }

    private static String paramName(Parameter[] parameters, int position, ConstructorProperties parameterNames) {
        Parameter parameter = parameters[position];
        ColumnName dbName = parameter.getAnnotation(ColumnName.class);
        if (dbName != null) {
            return dbName.value();
        }
        if (parameterNames != null) {
            return parameterNames.value()[position];
        }
        return parameter.getName();
    }

    private String debugName(Parameter parameter) {
        return String.format("%s constructor parameter %s", this.constructor.getDeclaringClass().getSimpleName(), parameter.getName());
    }

    private T construct(Object[] params) {
        try {
            return this.constructor.newInstance(params);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }
}

