/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.auth;

import com.alibaba.csp.sentinel.dashboard.auth.AuthService;
import com.alibaba.csp.sentinel.dashboard.auth.LoginAuthenticationFilter;
import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.util.AntPathMatcher;

public class DefaultLoginAuthenticationFilter
implements LoginAuthenticationFilter {
    private static final AntPathMatcher PATH_MATCHER = new AntPathMatcher();
    private static final String URL_SUFFIX_DOT = ".";
    @Value(value="#{'${auth.filter.exclude-urls}'.split(',')}")
    private List<String> authFilterExcludeUrls;
    @Value(value="#{'${auth.filter.exclude-url-suffixes}'.split(',')}")
    private List<String> authFilterExcludeUrlSuffixes;
    private final AuthService<HttpServletRequest> authService;

    public DefaultLoginAuthenticationFilter(AuthService<HttpServletRequest> authService) {
        this.authService = authService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String servletPath = httpRequest.getServletPath();
        boolean authFilterExcludeMatch = this.authFilterExcludeUrls.stream().anyMatch(authFilterExcludeUrl -> PATH_MATCHER.match(authFilterExcludeUrl, servletPath));
        if (authFilterExcludeMatch) {
            chain.doFilter(request, response);
            return;
        }
        for (String authFilterExcludeUrlSuffix : this.authFilterExcludeUrlSuffixes) {
            if (StringUtils.isBlank((String)authFilterExcludeUrlSuffix)) continue;
            if (!authFilterExcludeUrlSuffix.startsWith(URL_SUFFIX_DOT)) {
                authFilterExcludeUrlSuffix = URL_SUFFIX_DOT + authFilterExcludeUrlSuffix;
            }
            if (!servletPath.endsWith(authFilterExcludeUrlSuffix)) continue;
            chain.doFilter(request, response);
            return;
        }
        AuthService.AuthUser authUser = this.authService.getAuthUser(httpRequest);
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (authUser == null) {
            httpResponse.setStatus(HttpStatus.UNAUTHORIZED.value());
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

