/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.rpc;

import io.netty.util.ReferenceCountUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetlinks.core.Payload;
import org.jetlinks.core.codec.Codec;
import org.jetlinks.core.codec.Codecs;
import org.jetlinks.core.ipc.IpcDefinition;
import org.jetlinks.core.ipc.IpcInvoker;
import org.jetlinks.core.ipc.IpcInvokerBuilder;
import org.jetlinks.core.ipc.IpcService;
import org.jetlinks.supports.rpc.IpcRpcServiceFactory;
import org.jetlinks.supports.rpc.MethodRequest;
import org.jetlinks.supports.rpc.MethodRequestCodec;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ServiceConsumer
implements Disposable {
    private final Disposable disposable;
    private final Class<?> serviceInterface;
    private final Map<String, MethodInvoker> mappings = new HashMap<String, MethodInvoker>();
    private final Logger log;

    ServiceConsumer(IpcService ipcService, String address, Object instance, Class<?> serviceInterface) {
        this.serviceInterface = serviceInterface;
        for (Method method : serviceInterface.getMethods()) {
            this.mappings.put(method.getName() + ":" + method.getParameterCount(), this.createInvoker(method, instance));
        }
        IpcDefinition definition = IpcDefinition.of((String)address, (Codec)IpcRpcServiceFactory.responseCodec, (Codec)IpcRpcServiceFactory.responseCodec);
        this.disposable = ipcService.listen(definition, this.createInvoker());
        this.log = LoggerFactory.getLogger(serviceInterface);
    }

    private IpcInvoker<Payload, Payload> createInvoker() {
        return IpcInvokerBuilder.newBuilder().name(this.serviceInterface.getName()).forRequest(request -> Mono.from(this.invoke((Payload)request))).forRequestStream(request -> Flux.from(this.invoke((Payload)request))).forFireAndForget(request -> Mono.from(this.invoke((Payload)request)).then()).build();
    }

    protected static List<Codec<Object>> createMethodArgsCodec(Method method) {
        ArrayList<ResolvableType> argTypes = new ArrayList<ResolvableType>();
        for (int i = 0; i < method.getParameterCount(); ++i) {
            ResolvableType resolvableType = ResolvableType.forMethodParameter((Method)method, (int)i);
            if (resolvableType.isAssignableFrom(Publisher.class)) {
                throw new UnsupportedOperationException("unsupported publisher arg type :" + method);
            }
            argTypes.add(resolvableType);
        }
        return argTypes.stream().map(Codecs::lookup).collect(Collectors.toList());
    }

    private MethodInvoker getInvoker(String method, int argCount) {
        return this.mappings.get(method + ":" + argCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Publisher<Payload> invoke(Payload request) {
        try {
            MethodInvoker[] temp = new MethodInvoker[1];
            MethodRequest methodRequest = MethodRequestCodec.decode(request, (methodName, argCount) -> {
                temp[0] = this.getInvoker((String)methodName, (int)argCount);
                return temp[0].getRequestCodecs();
            });
            if (this.log.isDebugEnabled()) {
                if (methodRequest.getArgs() != null && methodRequest.getArgs().length > 0) {
                    this.log.debug("invoke local service: {}({})", (Object)methodRequest.getMethod(), (Object)methodRequest.getArgs());
                } else {
                    this.log.debug("invoke local service: {}()", (Object)methodRequest.getMethod());
                }
            }
            Publisher<Payload> publisher = temp[0].invoke(methodRequest);
            return publisher;
        }
        finally {
            ReferenceCountUtil.safeRelease((Object)request);
        }
    }

    private MethodInvoker createInvoker(Method method, Object instance) {
        return new MethodInvoker(instance, method);
    }

    public void dispose() {
        this.disposable.dispose();
    }

    public boolean isDisposed() {
        return this.disposable.isDisposed();
    }

    static class MethodInvoker {
        final Method method;
        final Object instance;
        final Codec<Object> responseEncoder;
        final List<Codec<Object>> requestCodecs;

        public MethodInvoker(Object instance, Method method) {
            this.instance = instance;
            this.method = method;
            this.responseEncoder = Codecs.lookup((ResolvableType)ResolvableType.forMethodReturnType((Method)method));
            this.requestCodecs = ServiceConsumer.createMethodArgsCodec(method);
        }

        public List<Codec<Object>> getRequestCodecs() {
            return this.requestCodecs;
        }

        Publisher<Payload> invoke(MethodRequest request) {
            Object res = this.method.invoke(this.instance, request.getArgs());
            if (res instanceof Mono) {
                return ((Mono)res).map(arg_0 -> this.responseEncoder.encode(arg_0));
            }
            if (res instanceof Flux) {
                return ((Flux)res).map(arg_0 -> this.responseEncoder.encode(arg_0));
            }
            return Mono.empty();
        }
    }
}

