/*
 * Decompiled with CFR 0.152.
 */
package mockit;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.classGeneration.ConcreteSubclass;
import mockit.internal.mockups.CaptureOfMockedUpImplementations;
import mockit.internal.mockups.MockClassSetup;
import mockit.internal.mockups.MockedImplementationClass;
import mockit.internal.startup.Startup;
import mockit.internal.state.MockClasses;
import mockit.internal.state.TestRun;
import mockit.internal.util.ConstructorReflection;
import mockit.internal.util.GeneratedClasses;
import mockit.internal.util.MockInvocationHandler;

public abstract class MockUp<T> {
    @Nonnull
    private final Type mockedType;
    @Nullable
    private final Class<?> mockedClass;
    @Nullable
    private Set<Class<?>> classesToRestore;
    @Nullable
    private T mockInstance;
    @Nullable
    T invokedInstance;

    protected MockUp() {
        MockUp.validateMockingAllowed();
        MockUp<?> previousMockUp = this.findPreviouslyMockedClassIfMockUpAlreadyApplied();
        if (previousMockUp != null) {
            this.mockedType = previousMockUp.mockedType;
            this.mockedClass = previousMockUp.mockedClass;
            return;
        }
        this.mockedType = this.validateTypeToMock();
        if (this.mockedType instanceof Class) {
            Class classToMock = (Class)this.mockedType;
            this.mockedClass = this.redefineClassOrImplementInterface(classToMock);
        } else if (this.mockedType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)this.mockedType;
            Class classToMock = (Class)parameterizedType.getRawType();
            this.mockedClass = this.redefineClassOrImplementInterface(classToMock);
        } else {
            Type[] typesToMock = ((TypeVariable)this.mockedType).getBounds();
            this.mockedClass = typesToMock.length > 1 ? new MockedImplementationClass(this).createImplementation(typesToMock) : new CaptureOfMockedUpImplementations(this, typesToMock[0]).apply();
        }
    }

    private static void validateMockingAllowed() {
        if (TestRun.isInsideNoMockingZone()) {
            throw new IllegalStateException("Invalid place to apply a mock-up");
        }
    }

    @Nullable
    private MockUp<?> findPreviouslyMockedClassIfMockUpAlreadyApplied() {
        MockClasses.MockUpInstances mockUpInstances = TestRun.getMockClasses().findPreviouslyAppliedMockUps(this);
        if (mockUpInstances != null) {
            MockUp previousMockUp = mockUpInstances.initialMockUp;
            if (mockUpInstances.hasMockUpsForSingleInstances()) {
                return previousMockUp;
            }
            previousMockUp.tearDown();
        }
        return null;
    }

    @Nonnull
    private Type validateTypeToMock() {
        Type typeToMock = this.getTypeToMock();
        if (typeToMock instanceof WildcardType || typeToMock instanceof GenericArrayType) {
            String errorMessage = "Argument " + typeToMock + " for type parameter T of an unsupported kind";
            throw new UnsupportedOperationException(errorMessage);
        }
        return typeToMock;
    }

    @Nonnull
    private Type getTypeToMock() {
        Class currentClass = this.getClass();
        Type superclass;
        while (!((superclass = currentClass.getGenericSuperclass()) instanceof ParameterizedType)) {
            if (superclass == MockUp.class) {
                throw new IllegalArgumentException("No type to be mocked");
            }
            currentClass = (Class)superclass;
        }
        return ((ParameterizedType)superclass).getActualTypeArguments()[0];
    }

    @Nonnull
    private Class<T> redefineClassOrImplementInterface(@Nonnull Class<T> classToMock) {
        if (classToMock.isInterface()) {
            return this.createInstanceOfMockedImplementationClass(classToMock, this.mockedType);
        }
        Class realClass = classToMock;
        if (Modifier.isAbstract(classToMock.getModifiers())) {
            classToMock = new ConcreteSubclass(classToMock).generateClass();
        }
        this.classesToRestore = this.redefineMethods(realClass, classToMock, this.mockedType);
        return classToMock;
    }

    @Nonnull
    private Class<T> createInstanceOfMockedImplementationClass(@Nonnull Class<T> classToMock, @Nullable Type typeToMock) {
        return new MockedImplementationClass(this).createImplementation(classToMock, typeToMock);
    }

    @Nullable
    private Set<Class<?>> redefineMethods(@Nonnull Class<T> realClass, @Nonnull Class<T> classToMock, @Nullable Type genericMockedType) {
        if (TestRun.mockFixture().isMockedClass(realClass)) {
            throw new IllegalArgumentException("Class already mocked: " + realClass.getName());
        }
        return new MockClassSetup(realClass, classToMock, genericMockedType, this).redefineMethods();
    }

    protected MockUp(Class<?> classToMock) {
        if (classToMock == null) {
            throw new IllegalArgumentException("Null reference when expecting the class to mock");
        }
        MockUp.validateMockingAllowed();
        this.mockedType = classToMock;
        MockUp<?> previousMockUp = this.findPreviouslyMockedClassIfMockUpAlreadyApplied();
        if (previousMockUp != null) {
            this.mockedClass = previousMockUp.mockedClass;
            return;
        }
        if (classToMock.isInterface()) {
            this.mockedClass = this.createInstanceOfMockedImplementationClass(classToMock, classToMock);
        } else {
            this.mockedClass = classToMock;
            Class<?> realClass = classToMock;
            this.classesToRestore = this.redefineMethods(realClass, realClass, null);
            this.mockInstance = null;
        }
    }

    protected MockUp(T instanceToMock) {
        Class<?> classToMock;
        if (instanceToMock == null) {
            throw new IllegalArgumentException("Null reference when expecting the instance to mock");
        }
        MockUp.validateMockingAllowed();
        MockUp<?> previousMockUp = this.findPreviouslyMockedClassIfMockUpAlreadyApplied();
        if (previousMockUp != null) {
            this.mockedType = previousMockUp.mockedType;
            this.mockedClass = previousMockUp.mockedClass;
            return;
        }
        this.mockedType = classToMock = instanceToMock.getClass();
        this.mockedClass = classToMock;
        this.classesToRestore = this.redefineMethods(classToMock, classToMock, classToMock);
        this.setMockInstance(instanceToMock);
    }

    private void setMockInstance(@Nonnull T mockInstance) {
        TestRun.getMockClasses().addMock(this, mockInstance);
        this.mockInstance = mockInstance;
    }

    public final T getMockInstance() {
        if (this.invokedInstance == Void.class) {
            throw new IllegalStateException("Invalid attempt to get mock instance from inside static mocked method");
        }
        if (this.invokedInstance != null) {
            return this.invokedInstance;
        }
        if (this.mockInstance == null && this.mockedClass != null) {
            Object newInstance = GeneratedClasses.isGeneratedImplementationClass(this.mockedClass) ? GeneratedClasses.newInstance(this.mockedClass) : (Proxy.isProxyClass(this.mockedClass) ? MockInvocationHandler.newMockedInstance(this.mockedClass) : ConstructorReflection.newUninitializedInstance(this.mockedClass));
            this.setMockInstance(newInstance);
        }
        return this.mockInstance;
    }

    public final void tearDown() {
        MockClasses.MockUpInstances mockUpInstances = TestRun.getMockClasses().removeMock(this, this.mockInstance);
        if (!mockUpInstances.hasMockUpsForSingleInstances() && this.classesToRestore != null) {
            TestRun.mockFixture().restoreAndRemoveRedefinedClasses(this.classesToRestore);
            this.classesToRestore = null;
        }
    }

    static {
        Startup.verifyInitialization();
    }
}

