/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.Configuration;
import mockit.coverage.CoverageCheck;
import mockit.coverage.OutputFileGenerator;
import mockit.coverage.TestRun;
import mockit.coverage.data.CoverageData;
import mockit.coverage.modification.ClassModification;
import mockit.coverage.standalone.AgentLoader;
import mockit.coverage.standalone.Startup;

public final class CodeCoverage
implements ClassFileTransformer {
    private static CodeCoverage instance;
    @Nonnull
    private final ClassModification classModification;
    @Nonnull
    private final OutputFileGenerator outputGenerator;
    private boolean outputPendingForShutdown;
    private boolean inactive;

    public static void main(@Nonnull String[] args) {
        if (args.length == 1) {
            String pid = args[0];
            try {
                Integer.parseInt(pid);
                new AgentLoader(pid).loadAgent();
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        OutputFileGenerator generator = CodeCoverage.createOutputFileGenerator(null);
        generator.generateAggregateReportFromInputFiles(args);
    }

    @Nonnull
    private static OutputFileGenerator createOutputFileGenerator(@Nullable ClassModification classModification) {
        OutputFileGenerator generator = new OutputFileGenerator(classModification);
        CoverageData.instance().setWithCallPoints(generator.isWithCallPoints());
        return generator;
    }

    public CodeCoverage() {
        this(true, true);
    }

    private CodeCoverage(boolean checkIfAlreadyInitialized, boolean generateOutputOnShutdown) {
        if (checkIfAlreadyInitialized && Startup.isInitialized()) {
            throw new IllegalStateException("JMockit: coverage tool already initialized");
        }
        if (generateOutputOnShutdown && ("none".equals(Configuration.getProperty("output")) || "none".equals(Configuration.getProperty("classes")) || "none".equals(Configuration.getProperty("metrics")))) {
            throw new IllegalStateException("JMockit: coverage tool disabled");
        }
        this.classModification = new ClassModification();
        this.outputGenerator = CodeCoverage.createOutputFileGenerator(this.classModification);
        this.outputPendingForShutdown = true;
        instance = this;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                TestRun.terminate();
                if (CodeCoverage.this.outputPendingForShutdown) {
                    if (CodeCoverage.this.outputGenerator.isOutputToBeGenerated()) {
                        CodeCoverage.this.outputGenerator.generate(CodeCoverage.this);
                    }
                    new CoverageCheck().verifyThresholds();
                }
                Startup.instrumentation().removeTransformer(CodeCoverage.this);
            }
        });
    }

    @Nonnull
    public static CodeCoverage create(boolean generateOutputOnShutdown) {
        instance = new CodeCoverage(false, generateOutputOnShutdown);
        return instance;
    }

    public static void resetConfiguration() {
        Startup.instrumentation().removeTransformer(instance);
        CoverageData.instance().clear();
        Startup.instrumentation().addTransformer(CodeCoverage.create(false));
        CodeCoverage.instance.outputPendingForShutdown = false;
    }

    public static void generateOutput(boolean resetState) {
        CodeCoverage.instance.outputGenerator.generate(null);
        CodeCoverage.instance.outputPendingForShutdown = false;
        if (resetState) {
            CoverageData.instance().reset();
        }
    }

    @Override
    @Nullable
    public byte[] transform(@Nullable ClassLoader loader, @Nonnull String internalClassName, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, @Nonnull byte[] originalClassfile) {
        if (loader == null || classBeingRedefined != null || protectionDomain == null || this.inactive) {
            return null;
        }
        String className = internalClassName.replace('/', '.');
        return this.classModification.modifyClass(className, protectionDomain, originalClassfile);
    }

    void deactivate() {
        this.inactive = true;
    }
}

